package
{
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.display.Sprite;
	import flash.desktop.*;
	import qnx.events.QNXApplicationEvent;
	import qnx.system.QNXApplication;

	[SWF( height="600", width="1024", frameRate="30", backgroundColor="#FFFFFF" )]	

	public class DemoApp extends Sprite
	{
		public static const BG_MAX_NUM:int = 3;
		public static var bg_cur:Number = 0;

		public static const LOGO_MAX_NUM:int = 2;
		public static var logo_cur:Number = 0;
		
		public static var bg:Vector.<AddBackground> = new Vector.<AddBackground>( BG_MAX_NUM, true );
		public static var logo:Vector.<MovingImage> = new Vector.<MovingImage>( LOGO_MAX_NUM, true );

		private var _menu:MenuBar;
		public var bg_images:Array = ["background01.jpg", "background02.jpg", "background03.jpg"];

		public function DemoApp()
		{
			initializeUI();
			QNXApplication.qnxApplication.addEventListener( QNXApplicationEvent.SWIPE_DOWN, showAppMenu );
			super();
		}

		public function FirstImage():void
		{
			stage.addEventListener( Event.ENTER_FRAME , init );
		}

		private function initializeUI():void
		{
			stage.removeEventListener( Event.ENTER_FRAME , init );
			stage.addEventListener( MouseEvent.MOUSE_DOWN , groundClick );

			for (var i:int = 0; i < BG_MAX_NUM; i++ ) {
				bg[i] = new AddBackground( bg_images[i] );
				bg[i].visible = false;
				addChild( bg[i] );
			}
			bg[bg_cur].visible = true;

			for ( i = 0; i < LOGO_MAX_NUM; i++ ) {
				logo[i] = new MovingImage( i + 1 );
				logo[i].visible = false;
				addChild( logo[i] );
				logo[i].init( );
			}
			logo[0].visible = true;

			// Create menu
			_menu = new MenuBar();
			addChild( _menu );
		}

		private function showAppMenu( event:QNXApplicationEvent ):void
		{
			if( ! _menu.isVisible() ) 
			      _menu.show();
		}

		private function groundClick( event:MouseEvent ):void
		{
			if( _menu.isVisible() )
			      _menu.processEvent( event );
		}

		public static function changeBg( index:Number ):void
		{
			bg[bg_cur].visible = false;
			bg[index].visible = true;
			bg_cur = index;
		}

		public static function changeLogo( index:Number ):void
		{
			logo[logo_cur].visible = false;
			logo[index].visible = true;
			logo_cur = index;
		}
	}
}
