#!/bin/sh

PTERMRC_F="$HOME/.ph/pterm/pterm.rc"
PTERMRC_D="$HOME/.ph/pterm/"
PTERMRC_BK=$PTERMRC_F.$(date +%y%m%d%H%M%S)
HOSTNAME=`hostname`
KBD_F="/etc/system/trap/.KEYBOARD.$HOSTNAME"
KBD_BK=$KBD_F.$(date +%y%m%d%H%M%S)
KBD_F2="/etc/system/trap/.KEYBOARD"
KBD_BK2=$KBD_F2.$(date +%y%m%d%H%M%S)
PROJECT="CBD BC QNX6.5.0 Cyrillic Patch"


echo "$PROJECT"
echo "support: support@kpda.ru"
echo

# Photon?
PH=`pidin -P Photon | grep Photon`
if [ "$?" -eq "0" ]
then
    echo "Error: Photon is running"
    echo
    echo "$PROJECT: Installation aborted"
    exit
fi
echo "Installation:"

# Install PHF font file
cp -f ./font/*.phf /usr/photon/font_repository/
/usr/photon/bin/mkfontdir -d /usr/photon/font_repository
echo "[1/4] Fonts installed"
sleep 1

# Modify keyboard definition file
if [ -f "$KBD_F" ]
then
    cp $KBD_F $KBD_BK
fi
echo "1" > $KBD_F
echo "en_US_101.kbd" >> $KBD_F
echo "ru_RU_102.kbd" >> $KBD_F
if [ -f "$KBD_F2" ]
then
    cp $KBD_F2 $KBD_BK2
fi
echo "1" > $KBD_F2
echo "en_US_101.kbd" >> $KBD_F2
echo "ru_RU_102.kbd" >> $KBD_F2
echo "[2/4] Keyboard definition file modified"
sleep 1

# Create charset files
cp -f ./charset/cp866.cs $HOME/cp866.cs
cp -f ./charset/cp1251.cs $HOME/cp1251.cs
cp -f ./charset/koi8r.cs $HOME/koi8r.cs
echo "[3/4] Charset files created"
sleep 1

# Create configuration file
if [ -f "$PTERMRC_F" ]
then
    cp $PTERMRC_F $PTERMRC_BK
fi
if [ ! -d "$PTERMRC_D" ]
then
    mkdir "$PTERMRC_D"
fi
cp -f ./rc/pterm.rc $PTERMRC_F
echo "[4/4] Configuration file created"
sleep 1

echo
echo "$PROJECT: Installation completed"
