#!/bin/sh

# Build script for XZ Utils 5.0.1
# (c) CBD BC, Oleg Bolshakov, 2011
# http://www.kpda.ru

VERS=5.0.1	# SAMBA version
JOBS=12		# Number of make jobs

TRG=i486-pc-nto-qnx6.5.0	# Target platform
TRG_PREFIX=x86			# Target platform prefix
PREFIX=usr			# Install prefix

CFLAGS=
LDFLAGS=
CONFOPT=

# Unpack source
rm -rf xz-${VERS}-${TRG} xz-${VERS}
tar xf xz-${VERS}.tar.xz


# Build xz
UPDIR=`pwd`
cd xz-${VERS}
LIBS="-lsocket" ./configure --host=${TRG} --prefix=/${PREFIX} ${CONFOPT}
make -j ${JOBS}
make prefix=${UPDIR}/xz-${VERS}-${TRG}/${TRG_PREFIX}/${PREFIX} install
cd ${UPDIR}


# Create bundle
UPDIR=`pwd`
cd xz-${VERS}-${TRG}
rm -rf ${TRG_PREFIX}/${PREFIX}/share/man
tar --owner=root --group=root -jcf ../xz-${VERS}-${TRG}-`date +%Y%m%d`.tar.bz2 *
cd ${UPDIR}


# Clean
rm -rf xz-${VERS}-${TRG} xz-${VERS}

