/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 26/11/2009
 * Dev:  A. Docuchaev
 */


/* event.c */


#include "l783m.h"


struct sigevent             irq_notifier;


/*
 * Init ISR notify event
 */
void init_isr( void )
{
    irq_notifier.sigev_notify = SIGEV_INTR;
}

/*
 * Interrupt handler
 */
const struct sigevent * irq_handler( void *area, int id )
{
    l783m_t                 *l783m         = (l783m_t *)area;
    register int            prev_idma_addr = 0;
    register int            adc_fifo_ptr   = 0,
                            adc_fifo_start = 0,
                            adc_fifo_end   = 0,
                            adc_fifo_size  = 0,
                            wd             = 0,
                            tmp            = 0;
    register int            sz             = 0;     /* Count of received bytes */
    register int            reply          = 0;
    register uint64_t       adc_read_st_cc = 0;

    InterruptMask( (int)l783m->board_info.InterruptLine, l783m->iid );

    /* Save IDMA addr */
    prev_idma_addr  = l783m->idma_addr;

    /* Is this our IRQ */
    if ( !( in32( l783m->board_info.bi.ioplx + PLX_REG_INTCSR ) & PLX_REG_INTCSR_LI1S ) ) {
        InterruptUnmask( (int)l783m->board_info.InterruptLine, l783m->iid );
        return (NULL);
    }

    /* Process interrupt */
    if ( l783m->adc_start ) {

        /* Get read time */
        adc_read_st_cc = ClockCycles();

        adc_fifo_ptr = read_dsp_dm_word( l783m, BIOS_VARIABLE_ADC_FIFO_PTR +
                                         l783m->board_info.bi.base_dsp_dm_offset );
        adc_fifo_start = read_dsp_dm_word( l783m, BIOS_VARIABLE_ADC_FIFO_BASE +
                                           l783m->board_info.bi.base_dsp_dm_offset );
        adc_fifo_size = read_dsp_dm_word( l783m, BIOS_VARIABLE_ADC_FIFO_LENGTH +
                                          l783m->board_info.bi.base_dsp_dm_offset );
        adc_fifo_end = adc_fifo_start + adc_fifo_size;
        if ( l783m->i_rbuf_index == 0 )
            l783m->i_rbuf_index = adc_fifo_ptr;

        while ( l783m->i_rbuf_index != adc_fifo_ptr ) {

            if ( adc_fifo_ptr < l783m->i_rbuf_index )
                wd = adc_fifo_end - l783m->i_rbuf_index;
            else
                wd = adc_fifo_ptr - l783m->i_rbuf_index;

            tmp = (l783m->i_rbuf.sz - l783m->i_rbuf.write_idx) / sizeof(uint16_t);
            if ( wd > tmp )
                wd = tmp;
            sz = wd * sizeof(uint16_t);

            read_dsp_dm( l783m, l783m->i_rbuf_index, (uint16_t *)(l783m->i_rbuf.data + l783m->i_rbuf.write_idx), wd );
            l783m->descriptor.adc_data_received += sz;

            l783m->i_rbuf.write_idx = (l783m->i_rbuf.write_idx + sz) % l783m->i_rbuf.sz;

            l783m->i_rbuf_index += wd;
            if ( l783m->i_rbuf_index >= adc_fifo_end )
                l783m->i_rbuf_index = adc_fifo_start;

            reply = 1;

        }

        if ( l783m->ir_fixed )
            l783m->i_rbuf.write_idx = 0;

        /* Get read time */
        l783m->adc_read_iv_cc = ClockCycles() - adc_read_st_cc;

        /* Get time between 2 interrupts */
        if ( l783m->adc_int_st_cc == 0 )
            l783m->adc_int_st_cc = ClockCycles();
        else {
            l783m->adc_int_ed_cc = ClockCycles();
            l783m->adc_int_iv_cc = l783m->adc_int_ed_cc - l783m->adc_int_st_cc;
            l783m->adc_int_st_cc = l783m->adc_int_ed_cc;
        }

    }

    /* Clear IRQ source */
    out16( l783m->board_info.bi.base + DSP_RESET_ADDRESS, 0 );

    /* Restore IDMA address */
    l783m->idma_addr = prev_idma_addr;
    if ( prev_idma_addr >= 0 )
        out16( l783m->board_info.bi.base + IDMA_ADDR, prev_idma_addr);

    InterruptUnmask( (int)l783m->board_info.InterruptLine, l783m->iid );

    if ( reply )
        return ( &irq_notifier );
    else
        return (NULL);
}
