PATH_SEP=/
CC=g++
RM=rm -fr
CP=cp
RHAP_FLAGS=
AR=ar
ARFLAGS=-rvu
DEFAULT_CPP_FLAGS=-g
ADDED_CPP_FLAGS = $(DEFAULT_CPP_FLAGS) -I.. -I../osconfig/mingw -Dmingw $(RHAP_FLAGS)

CPP_EXT=.cpp
H_EXT=.h
OBJ_EXT=.o

targets=tomtrace  tomtraceRiC

.DEFAULT : all

.PHONY : all

.FAILED :
	$(RM) $(OBJS)


.SUFFIXES: .cpp

.cpp.o:
	$(CC) $(ADDED_CPP_FLAGS) $(CPPFLAGS) -c $<

ifeq ($(CFG),tomtrace)
RHAP_FLAGS:=-DOMTRACER
all: mingw$(CFG).a
else
ifeq ($(CFG),tomtraceRiC)
RHAP_FLAGS:=-DOMTRACER -DRIC_APP -I../../LangC
all: mingw$(CFG).a
else
all:
	@echo "Usage: $(MAKE) all CFG=<target>."
	@echo "where target is one of $(targets)"
endif
endif

include tomFiles.list

SRCS = $(TOM_SRC)
HDRS = $(TOM_INC)
OBJS = $(TOM_OBJ)	

define BUILD_LIB
$(AR) $(ARFLAGS) $@ $?
$(CP) $@  ..$(PATH_SEP)lib$(PATH_SEP)$@
$(RM) $(OBJS) $@
endef

mingw$(CFG).a: $(OBJS)
	$(BUILD_LIB)



