PATH_SEP=/
CC=qcc -Vgcc_nto$(CPU)$(CPUEXT) -lang-c++ 
RM=rm -fr
CP=cp
RHAP_FLAGS=
AR=nto$(CPU)-ar
ARFLAGS=-rvus
DEFAULT_CPP_FLAGS=-g
ADDED_CPP_FLAGS = $(DEFAULT_CPP_FLAGS)  -I$(QNX_TARGET)/usr/include -I.. -I../osconfig/QNX -DUSE_IOSTREAM -DQNX $(RHAP_FLAGS)

targets=aomtrace aomanim

.DEFAULT : all

.PHONY : all

.FAILED :
	$(RM) $(OBJS)

.SUFFIXES: .cpp

LIB_EXT=.a
OBJ_EXT=.o
CPP_EXT=.cpp
H_EXT=.h

.cpp.o:
	$(CC) $(ADDED_CPP_FLAGS) $(CPPFLAGS) -c $<

ifeq ($(CFG),aomtrace)
RHAP_FLAGS:=-DOMTRACER
all: qnx$(VERSION)$(CFG)$(CPU)$(CPUEXT).a

else
ifeq ($(CFG),aomanim)
RHAP_FLAGS:=-DOMANIMATOR
all: qnx$(VERSION)$(CFG)$(CPU)$(CPUEXT).a

else
all :
	@echo "Usage: $(MAKE) all CFG=<target>."
	@echo "where target is one of $(targets)"
endif
endif

include aomFiles.list

SRCS = $(AOM_SRC)
HDRS = $(AOM_HDR)
OBJS = $(AOM_OBJ)

define BUILD_LIB
$(AR) $(ARFLAGS) $@ $?
$(CP) $@  ..$(PATH_SEP)lib$(PATH_SEP)$@
$(RM) $(OBJS) $@
endef

qnx$(VERSION)aomtrace$(CPU)$(CPUEXT).a: $(OBJS)
	$(BUILD_LIB)

qnx$(VERSION)aomanim$(CPU)$(CPUEXT).a: $(OBJS)
	$(BUILD_LIB)




