PATH_SEP=/
CC=qcc -Vgcc_nto$(CPU)$(CPUEXT) -lang-c++ 
RM=rm -fr
CP=cp
RHAP_FLAGS=
AR=nto$(CPU)-ar
ARFLAGS=-rvus
DEFAULT_CPP_FLAGS=-g
ADDED_CPP_FLAGS = $(DEFAULT_CPP_FLAGS) -I$(QNX_TARGET)/usr/include  -I.. -I../osconfig/QNX -DUSE_IOSTREAM  $(RHAP_FLAGS)

targets=WebComponents

.DEFAULT : all

.PHONY : all

.FAILED :
	$(RM) $(OBJS)


.SUFFIXES: .cpp

.cpp.o:
	$(CC) $(ADDED_CPP_FLAGS) $(CPPFLAGS) -c $<

ifeq ($(CFG),WebComponents)
RHAP_FLAGS:=
all: qnx$(VERSION)$(CFG)$(CPU)$(CPUEXT).a
else
all :
	@echo "Usage: $(MAKE) all CFG=<target>."
	@echo "where target is one of $(targets)"
endif

CPP_EXT=.cpp
H_EXT=.h
OBJ_EXT=.o

SRCS = \
  BasicWebAdapter.cpp \
  CharAttrWebAdapter.cpp \
  ClassOperationWebAdapter.cpp \
  ClassWebAdapter.cpp \
  CStrAttrWebAdapter.cpp \
  DoubleAttrWebAdapter.cpp \
  EventReceptionWebAdapter.cpp \
  IntAttrWebAdapter.cpp \
  LongAttrWebAdapter.cpp \
  StaticBoolAttrWebAdapter.cpp \
  StaticCharAttrWebAdapter.cpp \
  StaticClassOperationWebAdapter.cpp \
  StaticCStrAttrWebAdapter.cpp \
  StaticDoubleAttrWebAdapter.cpp \
  StaticIntAttrWebAdapter.cpp \
  StaticLongAttrWebAdapter.cpp \
  StaticOMBooleanAttrWebAdapter.cpp \
  StaticOMStringAttrWebAdapter.cpp \
  StaticShortAttrWebAdapter.cpp \
  StaticUCharAttrWebAdapter.cpp \
  StaticUIntAttrWebAdapter.cpp \
  StaticULongAttrWebAdapter.cpp \
  StaticUShortAttrWebAdapter.cpp \
  ULongAttrWebAdapter.cpp \
  WebServicesMediator.cpp

HDRS = \
  BasicWebAdapter.h \
  CharAttrWebAdapter.h \
  ClassOperationWebAdapter.h \
  ClassWebAdapter.h \
  CppWebAdaptersPkg.h \
  CStrAttrWebAdapter.h \
  C_Interface.h \
  DoubleAttrWebAdapter.h \
  EventReceptionWebAdapter.h \
  IntAttrWebAdapter.h \
  LongAttrWebAdapter.h \
  StaticBoolAttrWebAdapter.h \
  StaticCharAttrWebAdapter.h \
  StaticClassElementsAdapters.h \
  StaticClassOperationWebAdapter.h \
  StaticCStrAttrWebAdapter.h \
  StaticDoubleAttrWebAdapter.h \
  StaticIntAttrWebAdapter.h \
  StaticLongAttrWebAdapter.h \
  StaticOMBooleanAttrWebAdapter.h \
  StaticOMStringAttrWebAdapter.h \
  StaticShortAttrWebAdapter.h \
  StaticUCharAttrWebAdapter.h \
  StaticUIntAttrWebAdapter.h \
  StaticULongAttrWebAdapter.h \
  StaticUShortAttrWebAdapter.h \
  TemplatedAdapters.h \
  ULongAttrWebAdapter.h \
  WebComponentsTypes.h \
  WebServicesMediator.h

OBJS = \
  BasicWebAdapter$(OBJ_EXT) \
  CharAttrWebAdapter$(OBJ_EXT) \
  ClassOperationWebAdapter$(OBJ_EXT) \
  ClassWebAdapter$(OBJ_EXT) \
  CStrAttrWebAdapter$(OBJ_EXT) \
  DoubleAttrWebAdapter$(OBJ_EXT) \
  EventReceptionWebAdapter$(OBJ_EXT) \
  IntAttrWebAdapter$(OBJ_EXT) \
  LongAttrWebAdapter$(OBJ_EXT) \
  StaticBoolAttrWebAdapter$(OBJ_EXT) \
  StaticCharAttrWebAdapter$(OBJ_EXT) \
  StaticClassOperationWebAdapter$(OBJ_EXT) \
  StaticCStrAttrWebAdapter$(OBJ_EXT) \
  StaticDoubleAttrWebAdapter$(OBJ_EXT) \
  StaticIntAttrWebAdapter$(OBJ_EXT) \
  StaticLongAttrWebAdapter$(OBJ_EXT) \
  StaticOMBooleanAttrWebAdapter$(OBJ_EXT) \
  StaticOMStringAttrWebAdapter$(OBJ_EXT) \
  StaticShortAttrWebAdapter$(OBJ_EXT) \
  StaticUCharAttrWebAdapter$(OBJ_EXT) \
  StaticUIntAttrWebAdapter$(OBJ_EXT) \
  StaticULongAttrWebAdapter$(OBJ_EXT) \
  StaticUShortAttrWebAdapter$(OBJ_EXT) \
  ULongAttrWebAdapter$(OBJ_EXT) \
  WebServicesMediator$(OBJ_EXT)

define BUILD_LIB
$(AR) $(ARFLAGS) $@ $?
$(CP) $@  ..$(PATH_SEP)lib$(PATH_SEP)$@
$(RM) $(OBJS) $@
endef

qnx$(VERSION)WebComponents$(CPU)$(CPUEXT).a: $(OBJS)
	$(BUILD_LIB)
