PATH_SEP=/
CC=gcc
RM=rm -fr
CP=cp
RHAP_FLAGS=
AR=ar
ARFLAGS=-rvu
DEFAULT_CFLAGS=-g
ADDED_CFLAGS = $(DEFAULT_CFLAGS) -I.. -I../osconfig/mingw -Dmingw $(RHAP_FLAGS)

targets=oxf oxfinst

.DEFAULT : all

.PHONY : all

.FAILED :
	$(RM) $(OBJS)


.SUFFIXES: .c

.c.o:
	$(CC) $(ADDED_CFLAGS) $(CFLAGS) -c $<

ifeq ($(CFG),oxf)
RHAP_FLAGS:=
all: mingw$(CFG).a

else
ifeq ($(CFG),oxfinst)
RHAP_FLAGS:=-D_OMINSTRUMENT
all: mingw$(CFG).a

else
all :
	@echo "Usage: $(MAKE) all CFG=<target>."
	@echo "where target is one of $(targets)"
endif
endif

C_EXT=.c
H_EXT=.h
OBJ_EXT=.o

include oxfFiles.list

SRCS = RiCOSNT$(C_EXT) \
  $(OXF_SRC)

HDRS = RiCOSNT$(H_EXT) \
  $(OXF_INC)

OBJS = RiCOSNT$(OBJ_EXT) \
  $(OXF_OBJ)

define BUILD_LIB
$(AR) $(ARFLAGS) $@ $?
$(CP) $@  ..$(PATH_SEP)lib$(PATH_SEP)$@
$(RM) $(OBJS) $@
endef

mingw$(CFG).a: $(OBJS)
	$(BUILD_LIB)
