PATH_SEP=/
CC=qcc -Vgcc_nto$(CPU)$(CPUEXT)
RM=rm -fr
CP=cp 
RHAP_FLAGS=
AR=nto$(CPU)-ar
ARFLAGS=-rvus
DEFAULT_CPP_FLAGS=-g

ifeq ($(DISTRIBUTION),TRUE)
DIST_FLAGS=-DRIC_DISTRIBUTED_SYSTEM
DIST_PREFIX=distrib
endif

ADDED_CPP_FLAGS = $(DEFAULT_CPP_FLAGS) -I$(QNX_TARGET)/usr/include -Wno-write-strings -I.. -I../osconfig/QNX -DQNX $(RHAP_FLAGS) $(DIST_FLAGS)

targets=oxf oxfinst distrib_oxf distrib_oxfinst

.DEFAULT : all

.PHONY : all

.FAILED :
	$(RM) $(OBJS)


.SUFFIXES: .c

.c.o:
	$(CC) $(ADDED_CPP_FLAGS) $(CPPFLAGS) -c $<

ifeq ($(CFG),oxf)
RHAP_FLAGS=-Wno-unused
all : qnx$(VERSION)$(CFG)$(DIST_PREFIX)$(CPU)$(CPUEXT).a

else
ifeq ($(CFG),oxfinst)
RHAP_FLAGS=-DUSE_IOSTREAM -D_OMINSTRUMENT -Wno-unused
all : qnx$(VERSION)$(CFG)$(DIST_PREFIX)$(CPU)$(CPUEXT).a

else
ifeq ($(CFG),distrib_oxf)
RHAP_FLAGS=-DRIC_DISTRIBUTED_SYSTEM -Wno-unused
all : qnx$(VERSION)$(CFG)$(DIST_PREFIX)$(CPU)$(CPUEXT).a

else
ifeq ($(CFG),distrib_oxfinst)
RHAP_FLAGS=-DUSE_IOSTREAM -D_OMINSTRUMENT -DRIC_DISTRIBUTED_SYSTEM -Wno-unused
all : qnx$(VERSION)$(CFG)$(DIST_PREFIX)$(CPU)$(CPUEXT).a

else
all :
	@echo "Usage: $(MAKE) all CFG=<target>".
	@echo "where target is one of $(targets)"
endif
endif
endif
endif


C_EXT=.c
H_EXT=.h
OBJ_EXT=.o

SRCS=\
	RiCOSQnx$(C_EXT)\
	RiCCollection$(C_EXT) \
	RiCEvent$(C_EXT) \
	RiCHeap$(C_EXT) \
	RiCList$(C_EXT) \
	RiCMap$(C_EXT) \
	RiCOxf$(C_EXT) \
	RiCQueue$(C_EXT) \
	RiCReactive$(C_EXT) \
	RiCStack$(C_EXT) \
	RiCString$(C_EXT) \
	RiCTask$(C_EXT) \
	RiCTimer$(C_EXT) \
	RiCHdlCls$(C_EXT) \
	MemAlloc$(C_EXT) \
	RiCMemoryManager$(C_EXT) \
	RiCProtected$(C_EXT) \
	RiCTypes$(C_EXT) \
	RiCOutput$(C_EXT) \
	RiCDefaultReactivePort$(C_EXT) \
	RiCDefaultMulticastReactivePort$(C_EXT) \
	IRiCReactive$(C_EXT) \
	RiCAddressSpace$(C_EXT)

HDRS=\
	RiCOSQnx$(H_EXT)\
	Ric$(H_EXT) \
	RiCCollection$(H_EXT) \
	RiCEvent$(H_EXT) \
	RiCHeap$(H_EXT) \
	RiCList$(H_EXT) \
	RiCMap$(H_EXT) \
	RiCOS$(H_EXT) \
	RiCOSWrap$(H_EXT) \
	RiCOxf$(H_EXT) \
	RiCProtected$(H_EXT) \
	RiCQueue$(H_EXT) \
	RiCReactive$(H_EXT) \
	RiCStack$(H_EXT) \
	RiCString$(H_EXT) \
	RiCTask$(H_EXT) \
	RiCTimer$(H_EXT) \
	RiCTypes$(H_EXT) \
	RiCHdlCls$(H_EXT) \
	MemAlloc$(H_EXT) \
	RiCMemoryManager$(H_EXT) \
	RiCProtected$(H_EXT) \
	RiCTypes$(H_EXT) \
	RiCOutput$(H_EXT) \
	RiCDefaultReactivePort$(H_EXT) \
	RiCDefaultMulticastReactivePort$(H_EXT) \
	IRiCReactive$(H_EXT) \
	RiCAddressSpace$(H_EXT)


OBJS=\
	RiCOSQnx$(OBJ_EXT)\
	RiCCollection$(OBJ_EXT) \
	RiCEvent$(OBJ_EXT) \
	RiCHeap$(OBJ_EXT) \
	RiCList$(OBJ_EXT) \
	RiCMap$(OBJ_EXT) \
	RiCOxf$(OBJ_EXT) \
	RiCQueue$(OBJ_EXT) \
	RiCReactive$(OBJ_EXT) \
	RiCStack$(OBJ_EXT) \
	RiCString$(OBJ_EXT) \
	RiCTask$(OBJ_EXT) \
	RiCTimer$(OBJ_EXT) \
	RiCHdlCls$(OBJ_EXT) \
	MemAlloc$(OBJ_EXT) \
	RiCMemoryManager$(OBJ_EXT) \
	RiCProtected$(OBJ_EXT) \
	RiCTypes$(OBJ_EXT) \
	RiCOutput$(OBJ_EXT) \
	RiCDefaultReactivePort$(OBJ_EXT) \
	RiCDefaultMulticastReactivePort$(OBJ_EXT) \
	IRiCReactive$(OBJ_EXT) \
	RiCAddressSpace$(OBJ_EXT)



define BUILD_LIB
$(AR) $(ARFLAGS) $@ $?
$(CP) $@  ..$(PATH_SEP)lib$(PATH_SEP)$@
$(RM) $(OBJS) $@
endef

qnx$(VERSION)$(CFG)$(DIST_PREFIX)$(CPU)$(CPUEXT).a: $(OBJS)
	$(BUILD_LIB)

