PATH_SEP=/
CC=gcc
RM=rm -fr
CP=cp
RHAP_FLAGS=
AR=ar
ARFLAGS=-rvu
DEFAULT_CFLAGS=-g
ADDED_CFLAGS = $(DEFAULT_CFLAGS) -I.. -I../osconfig/mingw  -Dmingw $(RHAP_FLAGS)

targets=omcomappl

.DEFAULT : all

.PHONY : all

.FAILED :
	$(RM) $(OBJS)


.SUFFIXES: .c

LIB_EXT=.a
OBJ_EXT=.o
C_EXT=.c
H_EXT=.h

.c.o:
	$(CC) $(ADDED_CFLAGS) $(CFLAGS) -c $<

ifeq ($(CFG),omcomappl)
RHAP_FLAGS:=-DOMAPPLICATION
all: mingw$(CFG).a

else
all :
	@echo "Usage: $(MAKE) all CFG=<target>."
	@echo "where target is one of $(targets)"
endif

include omcomFiles.list

SRCS = $(OMCOM_SRCS)

HDRS = $(OMCOM_HDRS) 

OBJS = $(OMCOM_OBJS)


define BUILD_LIB
$(AR) $(ARFLAGS) $@ $?
$(CP) $@  ..$(PATH_SEP)lib$(PATH_SEP)$@
$(RM) $(OBJS) $@
endef

mingw$(CFG).a: $(OBJS)
	$(BUILD_LIB)
