PATH_SEP=/
CC=qcc -Vgcc_nto$(CPU)$(CPUEXT)
RM=rm -fr
CP=cp
RHAP_FLAGS=
AR=nto$(CPU)-ar
ARFLAGS=-rvus
DEFAULT_CPP_FLAGS=-g

ifeq ($(DISTRIBUTION),TRUE)
DIST_FLAGS=-DRIC_DISTRIBUTED_SYSTEM
DIST_PREFIX=distributed
endif

ADDED_CPP_FLAGS = $(DEFAULT_CPP_FLAGS) -I$(QNX_TARGET)/usr/include -Wno-write-strings -I.. -I../osconfig/QNX -DQNX $(RHAP_FLAGS) $(DIST_FLAGS)

.DEFAULT : all

targets=aomtrace aomanim distrib_aomanim distrib_aomtrace

C_EXT=.c
H_EXT=.h
OBJ_EXT=.o

.PHONY : all

.FAILED :
	$(RM) $(OBJS)
	
include aomFiles.list

SRCS = $(AOM_SRC)

HDRS = $(AOM_HDR) 

OBJS = $(AOM_OBJ)

define BUILD_LIB
$(AR) $(ARFLAGS) $@ $?
$(CP) $@  ..$(PATH_SEP)lib$(PATH_SEP)$@
$(RM) $(OBJS) $@
endef

qnx$(VERSION)$(CFG)$(DIST_PREFIX)$(CPU)$(CPUEXT).a: $(OBJS)
	$(BUILD_LIB)


.SUFFIXES: .c

.c.o:
	$(CC) $(ADDED_CPP_FLAGS) $(CPPFLAGS) -c $<

ifeq ($(CFG),aomtrace)
RHAP_FLAGS:=-DOMTRACER -I../../LangCpp
all: qnx$(VERSION)$(CFG)$(DIST_PREFIX)$(CPU)$(CPUEXT).a

else
ifeq ($(CFG),aomanim)
RHAP_FLAGS:=-DOMANIMATOR
all: qnx$(VERSION)$(CFG)$(DIST_PREFIX)$(CPU)$(CPUEXT).a

else
ifeq ($(CFG),distrib_aomanim)
RHAP_FLAGS:=-DOMANIMATOR  -DRIC_DISTRIBUTED_SYSTEM
all: qnx$(VERSION)$(CFG)$(DIST_PREFIX)$(CPU)$(CPUEXT).a

else
ifeq ($(CFG),distrib_aomtrace)
RHAP_FLAGS:=-DOMTRACER -I../../LangCpp -DRIC_DISTRIBUTED_SYSTEM
all: qnx$(VERSION)$(CFG)$(DIST_PREFIX)$(CPU)$(CPUEXT).a

else
all :
	@echo "Usage: $(MAKE) all CFG=<target>."
	@echo "where target is one of $(targets)"
endif
endif
endif
endif

