PATH_SEP=/
CC=qcc -Vgcc_nto$(CPU)$(CPUEXT)
RM=rm -fr
CP=cp
RHAP_FLAGS=
AR=nto$(CPU)-ar
ARFLAGS=-rvus
DEFAULT_CPP_FLAGS=-g
ADDED_CPP_FLAGS = $(DEFAULT_CPP_FLAGS) -I$(QNX_TARGET)/usr/include -Wno-write-strings -I.. -I../osconfig/QNX -DQNX $(RHAP_FLAGS)

targets=WebComponents

.DEFAULT : all

.PHONY : all

.FAILED :
	$(RM) $(OBJS)


.SUFFIXES: .c

.c.o:
	$(CC) $(ADDED_CPP_FLAGS) $(CPPFLAGS) -c $<

ifeq ($(CFG),WebComponents)
RHAP_FLAGS:=
all: qnx$(VERSION)$(CFG)$(DIST_PREFIX)$(CPU)$(CPUEXT).a
else
all :
	@echo "Usage: $(MAKE) all CFG=<target>."
	@echo "where target is one of $(targets)"
endif

CPP_EXT=.cpp
H_EXT=.h
OBJ_EXT=.o

SRCS = \
    BasicWebAdapter.c \
	StaticCharAttrWebAdapter.c \
	CStrAttrWebAdapter.c \
	StaticCStrAttrWebAdapter.c \
	CWebAdaptersPkg.c \
	DoubleAttrWebAdapter.c \
	StaticDoubleAttrWebAdapter.c \
	EventReceptionWebAdapter.c \
	StaticEventReceptionWebAdapter.c \
	IntAttrWebAdapter.c \
	StaticIntAttrWebAdapter.c \
	LongAttrWebAdapter.c \
	StaticLongAttrWebAdapter.c \
	ObjectTypeOperationWebAdapter.c \
	StaticOperationWebAdapter.c \
	ObjectTypeWebAdapter.c \
	RiCBooleanAttrWebAdapter.c \
	StaticRiCBooleanAttrWebAdapter.c \
	RiCStringAttrWebAdapter.c \
	StaticRiCStringAttrWebAdapter.c \
	ShortAttrWebAdapter.c \
	StaticShortAttrWebAdapter.c \
	UCharAttrWebAdapter.c \
	StaticUCharAttrWebAdapter.c \
	UIntAttrWebAdapter.c \
	StaticUIntAttrWebAdapter.c \
	ULongAttrWebAdapter.c \
	StaticULongAttrWebAdapter.c \
	UShortAttrWebAdapter.c \
	StaticUShortAttrWebAdapter.c

HDRS = \
    BasicWebAdapter.h \
	CharAttrWebAdapter.h \
	StaticCharAttrWebAdapter.h \
	CStrAttrWebAdapter.h \
	StaticCStrAttrWebAdapter.h \
	CWebAdaptersPkg.h \
	C_Interface.h \
	DoubleAttrWebAdapter.h \
	StaticDoubleAttrWebAdapter.h \
	EventReceptionWebAdapter.h \
	StaticEventReceptionWebAdapter.h \
	IntAttrWebAdapter.h \
	StaticIntAttrWebAdapter.h \
	LongAttrWebAdapter.h \
	StaticLongAttrWebAdapter.h \
	ObjectTypeOperationWebAdapter.h \
	StaticOperationWebAdapter.h \
	ObjectTypeWebAdapter.h \
	RiCBooleanAttrWebAdapter.h \
	StaticRiCBooleanAttrWebAdapter.h \
	RiCStringAttrWebAdapter.h \
	StaticRiCStringAttrWebAdapter.h \
	ShortAttrWebAdapter.h \
	StaticShortAttrWebAdapter.h \
	UCharAttrWebAdapter.h \
	StaticUCharAttrWebAdapter.h \
	UIntAttrWebAdapter.h \
	StaticUIntAttrWebAdapter.h \
	ULongAttrWebAdapter.h \
	StaticULongAttrWebAdapter.h \
	UShortAttrWebAdapter.h \
	StaticUShortAttrWebAdapter.h \
	WebComponentsTypes.h


OBJS = \
    BasicWebAdapter.o \
	CharAttrWebAdapter.o \
	StaticCharAttrWebAdapter.o \
	CStrAttrWebAdapter.o \
	StaticCStrAttrWebAdapter.o \
	CWebAdaptersPkg.o \
	DoubleAttrWebAdapter.o \
	StaticDoubleAttrWebAdapter.o \
	EventReceptionWebAdapter.o \
	StaticEventReceptionWebAdapter.o \
	IntAttrWebAdapter.o \
	StaticIntAttrWebAdapter.o \
	LongAttrWebAdapter.o \
	StaticLongAttrWebAdapter.o \
	ObjectTypeOperationWebAdapter.o \
	StaticOperationWebAdapter.o \
	ObjectTypeWebAdapter.o \
	RiCBooleanAttrWebAdapter.o \
	StaticRiCBooleanAttrWebAdapter.o \
	RiCStringAttrWebAdapter.o \
	StaticRiCStringAttrWebAdapter.o \
	ShortAttrWebAdapter.o \
	StaticShortAttrWebAdapter.o \
	UCharAttrWebAdapter.o \
	StaticUCharAttrWebAdapter.o \
	UIntAttrWebAdapter.o \
	StaticUIntAttrWebAdapter.o \
	ULongAttrWebAdapter.o \
	StaticULongAttrWebAdapter.o \
	UShortAttrWebAdapter.o \
	StaticUShortAttrWebAdapter.o


define BUILD_LIB
$(AR) $(ARFLAGS) $@ $?
$(CP) $@  ..$(PATH_SEP)lib$(PATH_SEP)$@
$(RM) $(OBJS) $@
endef

qnx$(VERSION)$(CFG)$(DIST_PREFIX)$(CPU)$(CPUEXT).a: $(OBJS)
	$(BUILD_LIB)
