#!/bin/sh

# Build script for SAMBA 2.2.12
# (c) CBD BC, Oleg Bolshakov, 2011
# http://www.kpda.ru

VERS=2.2.12	# SAMBA version
JOBS=12		# Number of make jobs

# Prepare SAMBA source
rm -rf samba-${VERS} distro
tar xf samba-${VERS}.tar.gz

# Apply a patch
cd samba-${VERS}
zcat ../samba-${VERS}-qnx4.patch.gz | patch -p1

# Prepare and pre-install codepages
cd source
./configure --prefix=/usr/samba --sbindir=\$\{exec_prefix\}/bin
make -j ${JOBS} bin/make_unicodemap bin/make_smbcodepage
make installcp prefix=../../distro/usr/samba \
    BASEDIR=../../distro/usr/samba BINDIR=bin

# Configure for QNX4
make distclean
CC=wacc CFLAGS="-DQNX4" LDFLAGS="-M" LIBS="-llogin -lunix" \
ac_cv_c_bigendian=no ac_cv_c_char_unsigned=yes \
samba_cv_HAVE_GETTIMEOFDAY_TZ=yes \
ac_cv_path_passwd_program=/bin/passwd \
./configure  --host=i386-unknown-qnx4 --disable-cups \
    --prefix=/usr/samba --sbindir=\$\{exec_prefix\}/bin

# Build and pre-install
make LIBS="-llogin -lunix" -j ${JOBS}
make install prefix=../../distro/usr/samba BASEDIR=../../distro/usr/samba

# Move to distro
cd ../../distro

# Create setup script
cat > setup  << EOF
#!/bin/sh

# Add version to /etc/version
cat _samba_vers.txt >> /etc/version/samba
rm -f _samba_vers.txt

# Create symlinks
ln -sf /usr/samba/lib /etc/samba

# View contact information
echo
echo SAMBA 2
echo http://www.samba.org
echo
echo Build for QNX4.25 was made by CBD BC
echo e-mail: support@kpda.ru
echo http://forum.kpda.ru
echo
sleep 5
EOF
chmod +x setup

# Create version file
echo SAMBA ${VERS} runtime build created by CBD BC > _samba_vers.txt

# Add configs
cp ../samba-${VERS}/examples/smb.conf.default usr/samba/lib/
cp ../samba-${VERS}/packaging/SuSE/8.0/lmhosts usr/samba/lib/
chmod -x usr/samba/lib/lmhosts

# Create a package
tar --owner=root --group=root -zcf ../samba-${VERS}-qnx4-bin-`date +%Y%m%d`.tar.gz *

# Clean
cd ..
rm -rf samba-${VERS} distro

