PATH_SEP=/
CC=qcc -Vgcc_nto$(CPU)$(CPUEXT) -lang-c++ 
RM=rm -fr
CP=cp
RHAP_FLAGS=
AR=nto$(CPU)-ar
ARFLAGS=-rvus
DEFAULT_CPP_FLAGS=-g -DFVE_MODIF -DQNX
ADDED_CPP_FLAGS = $(DEFAULT_CPP_FLAGS)  -I$(QNX_TARGET)/usr/include  -I.. -I../osconfig/QNX -DUSE_IOSTREAM -DQNX $(RHAP_FLAGS)

targets=tomtrace

.DEFAULT : all

.PHONY : all

.FAILED :
	$(RM) $(OBJS)


.SUFFIXES: .cpp

.cpp.o:
	$(CC) $(ADDED_CPP_FLAGS) $(CPPFLAGS) -c $<

ifeq ($(CFG),tomtrace)
RHAP_FLAGS:=-DOMTRACER
all: qnx$(VERSION)$(CFG)$(CPU)$(CPUEXT).a

else
all:
	@echo "Usage: $(MAKE) all CFG=<target>."
	@echo "where target is one of $(targets)"
endif

SRCS = tomattr.cpp \
 tombrk.cpp \
 tomclass.cpp \
 tomdisp.cpp \
 tominst.cpp \
 tomlist.cpp \
 tommask.cpp \
 tommsg.cpp \
 tomobs.cpp \
 tomother.cpp \
 tomout.cpp \
 tompack.cpp \
 tomproxy.cpp \
 tomstate.cpp \
 tomstep.cpp \
 tomsys.cpp \
 tomthrd.cpp \
 toxf.cpp \
 tomrefresh.cpp \
 tomsilent.cpp \
 tomoperation.cpp


HDRS = tom.h \
 tomabso.h \
 tomattr.h \
 tombrk.h \
 tomclass.h \
 tomdisp.h \
 tominst.h \
 tomlist.h \
 tommask.h \
 tommsg.h \
 tomobs.h \
 tomother.h \
 tomout.h \
 tompack.h \
 tomproxy.h \
 tomstate.h \
 tomstep.h \
 tomstr.h \
 tomsys.h \
 tomthrd.h \
 toxf.h \
 tomrefresh.h \
 tomsilent.h \
 tomoperation.h

OBJS = tomattr.o \
 tombrk.o \
 tomclass.o \
 tomdisp.o \
 tominst.o \
 tomlist.o \
 tommask.o \
 tommsg.o \
 tomobs.o \
 tomother.o \
 tomout.o \
 tompack.o \
 tomproxy.o \
 tomstate.o \
 tomstep.o \
 tomsys.o \
 tomthrd.o \
 toxf.o \
 tomrefresh.o \
 tomsilent.o \
 tomoperation.o

define BUILD_LIB
$(AR) $(ARFLAGS) $@ $?
$(CP) $@  ..$(PATH_SEP)lib$(PATH_SEP)$@
$(RM) $(OBJS) $@
endef

qnx$(VERSION)tomtrace$(CPU)$(CPUEXT).a: $(OBJS)
	$(BUILD_LIB)



