PATH_SEP=/
CC=g++
RM=rm -fr
CP=cp
RHAP_FLAGS=
AR=ar
ARFLAGS=-rvu
DEFAULT_CPP_FLAGS=-g
ADDED_CPP_FLAGS = $(DEFAULT_CPP_FLAGS) -I.. -I../osconfig/mingw -Dmingw $(RHAP_FLAGS)


LIB_EXT=.a
OBJ_EXT=.o
CPP_EXT=.cpp
H_EXT=.h

targets=aomtrace aomanim

.DEFAULT : all

.PHONY : all

.FAILED :
	$(RM) $(OBJS)


.SUFFIXES: .cpp

.cpp.o:
	$(CC) $(ADDED_CPP_FLAGS) $(CPPFLAGS) -c $<

ifeq ($(CFG),aomtrace)
RHAP_FLAGS:=-DOMTRACER
all: mingw$(CFG).a

else
ifeq ($(CFG),aomanim)
RHAP_FLAGS:=-DOMANIMATOR
all: mingw$(CFG).a

else
all :
	@echo "Usage: $(MAKE) all CFG=<target>."
	@echo "where target is one of $(targets)"
endif
endif

include aomFiles.list

SRCS = $(AOM_SRC)
HDRS = $(AOM_HDR)
OBJS = $(AOM_OBJ)

define BUILD_LIB
$(AR) $(ARFLAGS) $@ $?
$(CP) $@  ..$(PATH_SEP)lib$(PATH_SEP)$@
$(RM) $(OBJS) $@
endef

mingw$(CFG).a: $(OBJS)
	$(BUILD_LIB)
