PATH_SEP=/
CC=gcc
RM=rm -fr
CP=cp
RHAP_FLAGS=
AR=ar
ARFLAGS=-rvu
DEFAULT_CFLAGS=-g
ADDED_CFLAGS = $(DEFAULT_CFLAGS) -I.. -I../osconfig/mingw -Dmingw $(RHAP_FLAGS)


LIB_EXT=.a
OBJ_EXT=.o
C_EXT=.c
H_EXT=.h

targets=aomtrace aomanim

.DEFAULT : all

.PHONY : all

.FAILED :
	$(RM) $(OBJS)


.SUFFIXES: .c

.c.o:
	$(CC) $(ADDED_CFLAGS) $(CFLAGS) -c $<

ifeq ($(CFG),aomtrace)
RHAP_FLAGS:=-DOMTRACER
all: mingw$(CFG).a

else
ifeq ($(CFG),aomanim)
RHAP_FLAGS:=-DOMANIMATOR
all: mingw$(CFG).a

else
all :
	@echo "Usage: $(MAKE) all CFG=<target>."
	@echo "where target is one of $(targets)"
endif
endif

include aomFiles.list

SRCS = $(AOM_SRC)
HDRS = $(AOM_HDR)
OBJS = $(AOM_OBJ)

define BUILD_LIB
$(AR) $(ARFLAGS) $@ $?
$(CP) $@  ..$(PATH_SEP)lib$(PATH_SEP)$@
$(RM) $(OBJS) $@
endef

mingw$(CFG).a: $(OBJS)
	$(BUILD_LIB)
