/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 05/10/2010
 * Dev:  A. Docuchaev
 */


/* in.c */


#include "pio.h"


uint32_t piod64_read32( piod64_dev_t *dev )
{
    register uint32_t   result;

    result = ( (uint32_t)in8( dev->base + PIO_D64_DIO_BYTE0 ) |
               ((uint32_t)in8( dev->base + PIO_D64_DIO_BYTE1 ) << 8) |
               ((uint32_t)in8( dev->base + PIO_D64_DIO_BYTE2 ) << 16) |
               ((uint32_t)in8( dev->base + PIO_D64_DIO_BYTE3 ) << 24) );

    return result;

}

uint16_t piod64_read16( piod64_dev_t *dev )
{
    register uint16_t   result;

    result = ( (uint32_t)in8( dev->base + PIO_D64_DIO_BYTE0 ) |
               (uint32_t)in8( dev->base + PIO_D64_DIO_BYTE1 ) << 8);

    return result;
}

uint8_t piod64_read8( piod64_dev_t *dev, uint8_t iline )
{
    if ( iline < 8 )
        return (uint8_t)in8( dev->base + PIO_D64_DIO_BYTE0 );
    else if ( iline < 16 )
        return (uint8_t)in8( dev->base + PIO_D64_DIO_BYTE1 );
    else if ( iline < 24 )
        return (uint8_t)in8( dev->base + PIO_D64_DIO_BYTE2 );
    else if ( iline < 32 )
        return (uint8_t)in8( dev->base + PIO_D64_DIO_BYTE3 );

    return (0x0);
}

uint8_t piod64_read1( piod64_dev_t *dev, uint8_t iline )
{
    if ( iline < 8 )
        return ((uint8_t)in8( dev->base + PIO_D64_DIO_BYTE0 ) >> iline) & 0x1;
    else if ( iline < 16 )
        return ((uint8_t)in8( dev->base + PIO_D64_DIO_BYTE1 ) >> (iline - 8)) & 0x1;
    else if ( iline < 24 )
        return ((uint8_t)in8( dev->base + PIO_D64_DIO_BYTE2 ) >> (iline - 16)) & 0x1;
    else if ( iline < 32 )
        return ((uint8_t)in8( dev->base + PIO_D64_DIO_BYTE3 ) >> (iline - 24)) & 0x1;

    return (0x0);
}
