#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>

#include <sys/sched.h>

#include "ramdisk.h"

extern unsigned char ram_file[];
extern unsigned ram_size;

char obuf[LZF_BUF_SIZE];

int main( int argc, char *argv[] )
{
	int		fd;
	int		i;
	unsigned short	icnt, ocnt;

	setprio( 0, 19 );

	if ( argc < 2 )
	{
		fprintf( stderr, "Useage: %s <output file>\n", argv[0] );
		exit( -1 );
	}

//	fprintf( stderr, "\nLoading: ." );

	for ( i = 0; i < 100; i++ )
	{
		if ( ( fd = open( argv[1], O_RDWR ) ) < 0 )
		{
//			sleep( 1 );
//			fprintf( stderr, "." );
			delay( 1 );
		}
		else
			break;
	}
	if ( fd < 0 )
	{
		perror( " open()" );
		exit( -1 );
	}

	i = 0;
	while ( i < ram_size )
	{
		icnt = ((unsigned)ram_file[i]) | ( ((unsigned)ram_file[i+1]) << 8 );
		i += 2;
		ocnt = lzf_decompress( &ram_file[i], icnt, obuf, LZF_BUF_SIZE );
		i += icnt;
//fprintf( stderr, "%d %d\n", icnt, ocnt );

		if ( write( fd, obuf, ocnt ) != ocnt )
		{
			perror( " write()" );
			exit( -1 );
		}
	}

	close( fd );

//	fprintf( stderr, " ok\n" );

	return ( 0 );
}
