//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: ReusableBaseStates
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/state.h $
//!	File version	: $Revision: 1.71 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:23 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef state_H 

#define state_H 

#include "IOxfEvent.h"
#include "IOxfReactive.h"
#include "OXFManager.h"

//----------------------------------------------------------------------------
// state.h                                                                  
//----------------------------------------------------------------------------

class AnimServices;
class AOMInstance;
class AOMSState;
class IOxfReactive;
class OMAndState;
class OMComponentState;
class OMFinalState;
class OMLeafState;
class OMOrState;
class OMState;

//## package Design::oxf::Services::ReusableBaseStates 


// Reusable statechart implementation support

// Make IReactive::TakeEventStatus literals available in state classes
//#[ type eventConsumed 
#define eventConsumed IOxfReactive::eventConsumed
//#]

// Make IReactive::TakeEventStatus literals available in state classes
//#[ type eventNotConsumed 
#define eventNotConsumed IOxfReactive::eventNotConsumed
//#]

// Make IReactive::TakeEventStatus literals available in state classes
//#[ type instanceReachTerminate 
#define instanceReachTerminate IOxfReactive::instanceReachTerminate
//#]

// Make IReactive::TakeEventStatus literals available in state classes
//#[ type instanceUnderDestruction 
#define instanceUnderDestruction IOxfReactive::instanceUnderDestruction
//#]


//## package Design::oxf::Services::ReusableBaseStates 


// The base state class
//## class OMState 
class RP_FRAMEWORK_DLL OMState  {

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :
    
    // Initialize
    // Argument OMState* par : 
    // The parent state
    //## operation OMState(OMState*) 
    OMState(OMState* par = 0) : stateHandle(0) ,parent(par) {
        //#[ operation OMState(OMState*) 
        //#]
    }
    
    
    //## auto_generated 
    virtual ~OMState();


////    Operations    ////
public :
    
    // Enter this state via the default transition
    //## operation entDef() 
    virtual void entDef()=0;
    
    // Enter a state via a history connector.
    //## operation entHist() 
    virtual void entHist();
    
    // Enter this state
    //## operation enterState() 
    virtual void enterState()=0;
    
    // Exit from this state
    //## operation exitState() 
    virtual void exitState()=0;
    
    // Get the last active state in this sub graph (for history connector support)
    //## operation getLastState() 
    virtual OMState* getLastState();
    
    // Get the active sub state
    //## operation getSubState() 
    virtual OMState* getSubState();
    
    // Handle the current event (of the reactive owner)
    //## operation handleEvent() 
    virtual IOxfReactive::TakeEventStatus handleEvent();
    
    // Check is this state is in the active states graph
    //## operation in() 
    virtual bool in()=0;
    
    // Check is this state is completed (the sub graph reached a final state)
    //## operation isCompleted() 
    virtual bool isCompleted();
    
    // Serialize the state graph (instrumentation)
    // Argument AOMSState* /*s*/ : 
    // The serialization data
    //## operation serializeStates(AOMSState) const 
    inline virtual void serializeStates(AOMSState* /*s*/) const {
        //#[ operation serializeStates(AOMSState) const 
        //#]
    }
    
    
    // Set the last active state in this sub graph (for history connector support)
    // Argument OMState* /*s*/ : 
    // The last state
    //## operation setLastState(OMState) 
    virtual void setLastState(OMState* /*s*/);
    
    // Set the active sub state
    // Argument OMState* /*s*/ : 
    // The new sub state
    //## operation setSubState(OMState) 
    virtual void setSubState(OMState* /*s*/);
    
    // 5.X compatibility API: handle the current event
    // Argument IOxfEvent::ID id : 
    // The current event id
    //## operation takeEvent(ID) 
    virtual int takeEvent(IOxfEvent::ID id);

protected :
    
    // Get the reactive owner of this state
    //## operation getConcept() const 
    virtual AOMInstance* getConcept() const;


////    Additional operations    ////
public :
    
    //## auto_generated 
    const char * getHandle() const;
    
    //## auto_generated 
    void setHandle(const char * p_stateHandle);
    
    //## auto_generated 
    OMState* getParent() const;
    
    //## auto_generated 
    void setParent(OMState* p_OMState);


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
protected :
    
    // The state name (for instrumentation)
    const char * stateHandle;		//## attribute stateHandle 
    

////    Relations and components    ////
public :
    
    // The parent state
    OMState* parent;		//## link parent 
    


};
//## package Design::oxf::Services::ReusableBaseStates 


// A non-concurrent composite state
//## class OMOrState 
class RP_FRAMEWORK_DLL OMOrState : public OMState {


////    Constructors and destructors    ////
public :
    
    // Initialize
    // Argument OMState* par : 
    // The parent state
    //## operation OMOrState(OMState) 
    OMOrState(OMState* par = 0) : OMState(par), subState(NULL)  {
        //#[ operation OMOrState(OMState) 
        //#]
    }
    
    
    //## auto_generated 
    virtual ~OMOrState();


////    Operations    ////
public :
    
    // Enter this state via the default transition
    //## operation entDef() 
    virtual void entDef();
    
    // Enter this state
    //## operation enterState() 
    virtual void enterState();
    
    // Exit from this state
    //## operation exitState() 
    virtual void exitState();
    
    // Check is this state is in the active states graph
    //## operation in() 
    inline virtual bool in() {
        //#[ operation in() 
        return parent->getSubState() == this;
        //#]
    }
    
    
    // Serialize the state graph (instrumentation)
    // Argument AOMSState* aomArg(s) : 
    // The serialization data
    //## operation serializeStates(AOMSState) const 
    
    //#[ ignore 
    #ifdef _OMINSTRUMENT
    //#]
    virtual void serializeStates(AOMSState* aomArg(s)) const;
    //#[ ignore 
    
    #endif // _OMINSTRUMENT
    //#]
    


////    Additional operations    ////
public :
    
    //## auto_generated 
    OMState* getSubState();
    
    //## auto_generated 
    void setSubState(OMState* p_OMState);


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void cleanUpRelations();


////    Relations and components    ////
public :
    
    // The direct sub state that is part of the active graph
    OMState* subState;		//## link subState 
    


};
//## package Design::oxf::Services::ReusableBaseStates 


// A part of an AND state or the root state
//## class OMComponentState 
class RP_FRAMEWORK_DLL OMComponentState : public OMOrState {


////    Constructors and destructors    ////
public :
    
    // Initialize
    // Argument OMState* par : 
    // The parent state
    //## operation OMComponentState(OMState) 
    OMComponentState(OMState* par = 0) : OMOrState(par), active(NULL)  {
        //#[ operation OMComponentState(OMState) 
        //#]
    }
    
    
    //## auto_generated 
    virtual ~OMComponentState();


////    Operations    ////
public :
    
    // Enter into this state
    //## operation enterState() 
    virtual void enterState();
    
    // Handle the current event
    //## operation handleEvent() 
    virtual IOxfReactive::TakeEventStatus handleEvent();
    
    // Check is this state is in the active states graph
    //## operation in() 
    virtual bool in();
    
    // 5.X compatibility API: handle the current event
    // Argument IOxfEvent::ID /*id*/ : 
    // The current event id
    //## operation takeEvent(ID) 
    virtual int takeEvent(IOxfEvent::ID /*id*/);


////    Additional operations    ////
public :
    
    //## auto_generated 
    OMState* getActive() const;
    
    //## auto_generated 
    void setActive(OMState* p_OMState);


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void cleanUpRelations();


////    Relations and components    ////
public :
    
    // The active sub state
    OMState* active;		//## link active 
    


};
//## package Design::oxf::Services::ReusableBaseStates 


// A simple state that doesn't contain additional states
//## class OMLeafState 
class RP_FRAMEWORK_DLL OMLeafState : public OMState {


////    Constructors and destructors    ////
public :
    
    // Initialize
    // Argument OMState* par : 
    // The parent state
    // Argument OMState* cmp : 
    // A parent component state
    //## operation OMLeafState(OMState,OMState) 
    OMLeafState(OMState* par, OMState* cmp);
    
    //## auto_generated 
    virtual ~OMLeafState();


////    Operations    ////
public :
    
    // Take the state default transition
    //## operation entDef() 
    virtual void entDef();
    
    // Enter the state
    //## operation enterState() 
    virtual void enterState();
    
    // Exit the state
    //## operation exitState() 
    virtual void exitState();
    
    // Check is this state is in the active states graph
    //## operation in() 
    virtual bool in();
    
    // Serialize the state graph (instrumentation)
    // Argument AOMSState* aomArg(s) : 
    // The serialization data
    //## operation serializeStates(AOMSState) const 
    
    //#[ ignore 
    #ifdef _OMINSTRUMENT
    //#]
    virtual void serializeStates(AOMSState* aomArg(s)) const;
    //#[ ignore 
    
    #endif // _OMINSTRUMENT
    //#]
    


////    Additional operations    ////
public :
    
    //## auto_generated 
    OMComponentState* getComponent() const;


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void cleanUpRelations();


////    Relations and components    ////
public :
    
    OMComponentState* component;		//## link component 
    


};
//## package Design::oxf::Services::ReusableBaseStates 


// A concurrent state
//## class OMAndState 
class RP_FRAMEWORK_DLL OMAndState : public OMLeafState {


////    Constructors and destructors    ////
public :
    
    // Initialize
    // Argument OMState* par : 
    // The parent state
    // Argument OMState* cmp : 
    // A parent OMComponentState
    //## operation OMAndState(OMState,OMState) 
    OMAndState(OMState* par, OMState* cmp);
    
    //## auto_generated 
    ~OMAndState();


////    Operations    ////
public :
    
    // Set the lock
    //## operation lock() 
    void lock();
    
    // Unset the lock
    //## operation unlock() 
    void unlock();


////    Additional operations    ////
private :
    
    //## auto_generated 
    bool get_lock() const;


////    Attributes    ////
private :
    
    // A locked flag
    bool _lock;		//## attribute _lock 
    

};
//## package Design::oxf::Services::ReusableBaseStates 


// UML Final state
//## class OMFinalState 
class RP_FRAMEWORK_DLL OMFinalState : public OMLeafState {


////    Constructors and destructors    ////
public :
    
    // Initialize
    // Argument IOxfReactive* cpt : 
    // The reactive owner
    // Argument OMState* par : 
    // The parent state
    // Argument OMState* cmp : 
    // A parent component state
    // Argument const char* aomArg(hdl) : 
    // The state name
    //## operation OMFinalState(IOxfReactive,OMState,OMState,char*) 
    OMFinalState(IOxfReactive* cpt, OMState* par, OMState* cmp, const char* aomArg(hdl) = 0) : 
    OMLeafState(par, cmp) , concept(cpt)
    	 {
        //#[ operation OMFinalState(IOxfReactive,OMState,OMState,char*) 
        #ifdef _OMINSTRUMENT
        setHandle(hdl);
        #endif // _OMINSTRUMENT
        //#]
    }
    
    
    //## auto_generated 
    virtual ~OMFinalState();


////    Operations    ////
protected :
    
    // Get the reactive owner
    //## operation getConcept() const 
    
    //#[ ignore 
    #ifdef _OMINSTRUMENT
    //#]
    virtual AOMInstance* getConcept() const;
    //#[ ignore 
    
    #endif // _OMINSTRUMENT
    //#]
    


////    Additional operations    ////
public :
    
    //## auto_generated 
    void setConcept(IOxfReactive* p_IOxfReactive);


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void cleanUpRelations();


////    Relations and components    ////
private :
    
    // The reactive owner
    IOxfReactive* concept;		//## link concept 
    


};


#endif  
//
//! Log: $Log: state.h $
//! Log: Revision 1.71  2007/04/06 07:08:23  ilgiga
//! Log: bug fix 98191
//


