//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: ReusableBaseStates
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/state.cpp $
//!	File version	: $Revision: 1.72 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:23 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: state.cpp 1.72 2007/04/06 07:08:23 ilgiga Exp $";
#endif
//#]

#include "state.h"

//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
#include <aom/AnimServices.h>

//#[ ignore 
#endif //_OMINSTRUMENT
//#]
#include "IOxfReactive.h"

//----------------------------------------------------------------------------
// state.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::ReusableBaseStates 



//## package Design::oxf::Services::ReusableBaseStates 

//## class OMState 



OMState::~OMState() {
    cleanUpRelations();
}

void OMState::entHist() {
    //#[ operation entHist() 
    //#]
}

AOMInstance* OMState::getConcept() const {
    //#[ operation getConcept() const 
    return 0;
    //#]
}

OMState* OMState::getLastState() {
    //#[ operation getLastState() 
    return 0;
    //#]
}

OMState* OMState::getSubState() {
    //#[ operation getSubState() 
    return NULL;
    //#]
}

IOxfReactive::TakeEventStatus OMState::handleEvent() {
    //#[ operation handleEvent() 
    if (parent) {
    	return parent->handleEvent();
    }
    else {
    	return eventNotConsumed;
    }
    //#]
}

bool OMState::isCompleted() {
    //#[ operation isCompleted() 
    return true;
    //#]
}

void OMState::setLastState(OMState* /*s*/) {
    //#[ operation setLastState(OMState) 
    //#]
}

void OMState::setSubState(OMState* /*s*/) {
    //#[ operation setSubState(OMState) 
    //#]
}

int OMState::takeEvent(IOxfEvent::ID id) {
    //#[ operation takeEvent(ID) 
    int res = eventNotConsumed;
    if (parent)
    {
    	res = parent->takeEvent(id);
    }
    return res;
    //#]
}

const char *OMState::getHandle() const {
    return stateHandle;
}

void OMState::setHandle(const char * p_stateHandle) {
    stateHandle = p_stateHandle;
}

OMState* OMState::getParent() const {
    return parent;
}

void OMState::setParent(OMState* p_OMState) {
    parent = p_OMState;
}

void OMState::cleanUpRelations() {
    if(parent != 0)
        {
            parent = 0;
        }
}


//## package Design::oxf::Services::ReusableBaseStates 

//## class OMOrState 



OMOrState::~OMOrState() {
    cleanUpRelations();
}

void OMOrState::entDef() {
    //#[ operation entDef() 
    enterState();
    if(subState != NULL) {
    	subState->entDef();
    }
    //#]
}

void OMOrState::enterState() {
    //#[ operation enterState() 
    if (parent) {
    	parent->setSubState(this);
    }
    #ifdef _OMINSTRUMENT
    AnimServices::notifyStateEntered(getConcept(), getHandle());
    #endif
    //#]
}

void OMOrState::exitState() {
    //#[ operation exitState() 
    if(subState != NULL) {
    	subState->exitState();
    	subState = NULL;
    }
    #ifdef _OMINSTRUMENT
    AnimServices::notifyStateExited(getConcept(), getHandle());
    #endif
    //#]
}


//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
void OMOrState::serializeStates(AOMSState* aomArg(s)) const {
    //#[ operation serializeStates(AOMSState) const 
    AnimServices::addState(s, getHandle());
    if (subState != 0)
    {
    	subState->serializeStates(s);
    }
    //#]
}

//#[ ignore 

#endif // _OMINSTRUMENT
//#]

OMState* OMOrState::getSubState() {
    return subState;
}

void OMOrState::setSubState(OMState* p_OMState) {
    subState = p_OMState;
}

void OMOrState::cleanUpRelations() {
    if(subState != 0)
        {
            subState = 0;
        }
}


//## package Design::oxf::Services::ReusableBaseStates 

//## class OMComponentState 



OMComponentState::~OMComponentState() {
    cleanUpRelations();
}

void OMComponentState::enterState() {
    //#[ operation enterState() 
    #ifdef _OMINSTRUMENT
    AnimServices::notifyStateEntered(getConcept(), getHandle());
    #endif
    //#]
}

IOxfReactive::TakeEventStatus OMComponentState::handleEvent() {
    //#[ operation handleEvent() 
    return eventNotConsumed;
    //#]
}

bool OMComponentState::in() {
    //#[ operation in() 
    if (parent)           // Is It Root state 
    	return parent->in(); // Components are always in if their parent is in
    else
    	return 1;
    //#]
}

int OMComponentState::takeEvent(IOxfEvent::ID /*id*/) {
    //#[ operation takeEvent(ID) 
    return eventNotConsumed;
    //#]
}

OMState* OMComponentState::getActive() const {
    return active;
}

void OMComponentState::setActive(OMState* p_OMState) {
    active = p_OMState;
}

void OMComponentState::cleanUpRelations() {
    if(active != 0)
        {
            active = 0;
        }
}


//## package Design::oxf::Services::ReusableBaseStates 

//## class OMLeafState 



OMLeafState::OMLeafState(OMState* par, OMState* cmp) : OMState(par), component(static_cast<OMComponentState*>(cmp)) 
 {
    //#[ operation OMLeafState(OMState,OMState) 
    //#]
}

OMLeafState::~OMLeafState() {
    cleanUpRelations();
}

void OMLeafState::entDef() {
    //#[ operation entDef() 
    enterState();
    //#]
}

void OMLeafState::enterState() {
    //#[ operation enterState() 
    if (parent) {
    	parent->setSubState(this);
    }
    component->active = this;  // Setting the activeState of the component
    #ifdef _OMINSTRUMENT
    AnimServices::notifyStateEntered(getConcept(), getHandle());
    #endif
    //#]
}

void OMLeafState::exitState() {
    //#[ operation exitState() 
    #ifdef _OMINSTRUMENT
    AnimServices::notifyStateExited(getConcept(), getHandle());
    #endif
    //#]
}

bool OMLeafState::in() {
    //#[ operation in() 
    bool in_me = false;
    if (parent) {
    	in_me = (parent->getSubState() == this);
    }
    return in_me;
    //#]
}


//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
void OMLeafState::serializeStates(AOMSState* aomArg(s)) const {
    //#[ operation serializeStates(AOMSState) const 
    AnimServices::addState(s, getHandle());
    //#]
}

//#[ ignore 

#endif // _OMINSTRUMENT
//#]

OMComponentState* OMLeafState::getComponent() const {
    return component;
}

void OMLeafState::cleanUpRelations() {
    if(component != 0)
        {
            component = 0;
        }
}


//## package Design::oxf::Services::ReusableBaseStates 

//## class OMAndState 



OMAndState::OMAndState(OMState* par, OMState* cmp) : OMLeafState(par, cmp), _lock(false)
 {
    //#[ operation OMAndState(OMState,OMState) 
    //#]
}

OMAndState::~OMAndState() {
}

void OMAndState::lock() {
    //#[ operation lock() 
    _lock = true;
    //#]
}

void OMAndState::unlock() {
    //#[ operation unlock() 
    _lock = false;
    //#]
}

bool OMAndState::get_lock() const {
    return _lock;
}


//## package Design::oxf::Services::ReusableBaseStates 

//## class OMFinalState 



OMFinalState::~OMFinalState() {
    cleanUpRelations();
}


//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
AOMInstance* OMFinalState::getConcept() const {
    //#[ operation getConcept() const 
    return AnimServices::getAnimInstance(concept);
    //#]
}

//#[ ignore 

#endif // _OMINSTRUMENT
//#]

void OMFinalState::setConcept(IOxfReactive* p_IOxfReactive) {
    concept = p_IOxfReactive;
}

void OMFinalState::cleanUpRelations() {
    if(concept != 0)
        {
            concept = 0;
        }
}



//
//! Log: $Log: state.cpp $
//! Log: Revision 1.72  2007/04/06 07:08:23  ilgiga
//! Log: bug fix 98191
//


