////////////////////////////////////////////////////
//                                                //
//               QNX 4.25 - threads               //
//                  (Interface)                   //
//                   v.1.0.0.1                    //
//                                                //
//                                                //
//    file name : pthread.h                       //
//    date : 14.03.08                             //
//                                                //
//    Description :                               //
//         ,       //
//          QNX 4,        //
//       QNX 4:                                   //
//             - pthread_mutex_*                  //
//             - pthread_*                        //
//                                                //
////////////////////////////////////////////////////

////////////////////////////////////////////////////
///////////////////// HEADERS //////////////////////
////////////////////////////////////////////////////

	// QNX headers
		#include <sys/types.h>
		#include <sys/sched.h>
		#include <process.h>
		#include <unistd.h>
		#include <signal.h>
		#include <stdio.h>

////////////////////////////////////////////////////
//////////////////// CONSTANTS /////////////////////
////////////////////////////////////////////////////

	#define EOk			0;
	#define EFault		14;
	#define _NTO_SYNC_INITIALIZER	0xffffffff	/*   -1  count is 0=mutexes, 0(old),-5(new)=cond */
	#define PTHREAD_CREATE_JOINABLE				0x00
	#define PTHREAD_INHERIT_SCHED				0x00

////////////////////////////////////////////////////
///////////////////// MACROSES /////////////////////
////////////////////////////////////////////////////

	#undef __SYNC_T
	#define __SYNC_T \
		struct _sync \
		{ \
			int				count;		/* Count for recursive mutexs and semaphores */ \
			unsigned		owner;		/* Thread id (valid for mutex only) */ \
		}
	#undef __PTHREAD_ATTR_T
		/*struct sched_param {
			int sched_priority;
			int sched_reserved;
		} ;*/
	#define __PTHREAD_ATTR_T \
		struct _thread_attr { \
			int						flags; \
			int						inheritsched; \
			size_t					stacksize; \
			void					*stackaddr; \
			int						detachstate; \
			void					(*exitfunc)(void *status); \
			int						policy; \
			struct sched_param		param; \
			unsigned				guardsize; \
			unsigned				prealloc; \
			int						spare[2]; \
		}
	#undef __SYNC_ATTR_T
	#define __SYNC_ATTR_T \
		struct _sync_attr { \
			int		protocol; \
			int		flags; \
			int		prioceiling; \
			int		clockid; \
			int		reserved[4]; \
		}
////////////////////////////////////////////////////
////////////////////// TYPES ///////////////////////
////////////////////////////////////////////////////

	// Thread
		typedef __PTHREAD_ATTR_T	pthread_attr_t;
		typedef int					pthread_t;
	// Mutex
		typedef __SYNC_ATTR_T		sync_attr_t;
		typedef sync_attr_t			pthread_mutexattr_t;
		typedef __SYNC_T			sync_t;
		typedef sync_t				pthread_mutex_t;

////////////////////////////////////////////////////
////////////////////// FUNCS ///////////////////////
////////////////////////////////////////////////////

	///////////////////////////////////////////////
	////////////////// THREADS ////////////////////
	///////////////////////////////////////////////

		int pthread_create(pthread_t *__thr, pthread_attr_t *__attr, void *(*__start_routine)(void *), void *__arg);
		pthread_t pthread_self( void );
		int pthread_cancel( pthread_t thread );
		void pthread_exit(void *__value_ptr);
		int pthread_kill( pthread_t thread, int sig );
		int pthread_attr_init(pthread_attr_t *__attr);
		int pthread_attr_setstacksize(pthread_attr_t *__attr, size_t __stacksize);
		int pthread_attr_setdetachstate(pthread_attr_t *__attr, int __detachstate);
		int pthread_attr_setinheritsched(pthread_attr_t *__attr, int __inheritsched);

	///////////////////////////////////////////////
	/////////////////// SHED //////////////////////
	///////////////////////////////////////////////

		int pthread_setschedparam(pthread_t __thr, int __policy, struct sched_param *__param);
		int pthread_getschedparam( const pthread_t thread, int * policy, struct sched_param * param );

	///////////////////////////////////////////////
	////////////////// ACCESS /////////////////////
	///////////////////////////////////////////////

		int pthread_mutex_lock( pthread_mutex_t * mutex );
		int pthread_mutex_unlock( pthread_mutex_t * mutex );
		int pthread_mutex_destroy( pthread_mutex_t * mutex );
		int pthread_mutex_init(pthread_mutex_t *__mutex, const pthread_mutexattr_t *__attr);

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////   SIGNALS   /////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		int sigpause(int __sig);
