//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OXF
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/oxf.h $
//!	File version	: $Revision: 1.75 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:21 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef oxf_H 

#define oxf_H 

#include "rawtypes.h"
#include "ommemorymanager.h"
#include "OMTimerManagerDefaults.h"
#include "OXFRefLock.h"
#include "OXFPortMacros.h"

//----------------------------------------------------------------------------
// oxf.h                                                                  
//----------------------------------------------------------------------------

class AnimServices;
class IOxfActive;
class IOxfMemoryAllocator;
class IOxfTickTimerFactory;
class OMAnimHelper;
class OMDelay;
class OMMainThread;
class OMOS;
class OMReactive;
class OMThread;
class OMTimerManager;

//## package Design::oxf::Services::Initialization 


// The framework entrypoint.
// Provides initialization, startup and termination services.
//## class OXF 
class RP_FRAMEWORK_DLL OXF  {


////    Operations    ////
public :
    
    // Design level debugging support - de register a RTOS thread that is not associated with an IOxfActive object.
    // Argument void * aomArg(theHandle) : 
    // The RTOS thread handle
    //## operation animDeregisterForeignThread(void *) 
    static void animDeregisterForeignThread(void * aomArg(theHandle));
    
    // Design level debugging support - register a RTOS thread that is not associated with an IOxfActive object
    // Argument char* aomArg(name) : 
    // The RTOS thread name
    // Argument void * aomArg(theHandle) : 
    // The RTOS thread handle
    //## operation animRegisterForeignThread(char*,void *) 
    static void animRegisterForeignThread(char* aomArg(name), void * aomArg(theHandle));
    
    // Delay the calling thread for "t" units (currently milliseconds)
    // Argument OxfTimeUnit t : 
    // The delay time
    //## operation delay(OxfTimeUnit) 
    static void delay(OxfTimeUnit t);
    
    // Cleanup the framework objects
    //## operation end() 
    static void end();
    
    // initialize the framework in compatibility mode (timer, main thread, animation and etc.)
    // Argument int numProgArgs : 
    // The number of argument passed in progArgs
    // Argument char** progArgs : 
    // An argument list (similar to argv of the main)
    // Argument unsigned defaultPort : 
    // The animation port
    // Argument const char * defaultHost : 
    // Rhapsody host IP
    // Argument OxfTimeUnit ticktime : 
    // The framework tick-timer resolution
    // Argument unsigned maxTM : 
    // The max number of timeouts that can be waiting simultaneously
    // Argument bool isRealTimeModel : 
    // The framework tick-timer mode (real time when true or simulated otherwise)
    //## operation init(int,char*,unsigned ,const char * ,OxfTimeUnit,unsigned ,bool) 
    static bool init(int numProgArgs = 0, char** progArgs = NULL, unsigned defaultPort = 0, const char * defaultHost = 
    NULL, OxfTimeUnit ticktime = OMTimerManagerDefaults::defaultTicktime, unsigned maxTM = 
    OMTimerManagerDefaults::defaultMaxTM, bool isRealTimeModel = true);
    
    // initialize the framework (timer, main thread, animation and etc.)
    // Argument int aomArg(numProgArgs) : 
    // The number of argument passed in progArgs
    // Argument char** aomArg(progArgs) : 
    // An argument list (similar to argv of the main)
    // Argument unsigned aomArg(defaultPort) : 
    // The animation port
    // Argument const char * aomArg(defaultHost) : 
    // Rhapsody host IP
    // Argument OxfTimeUnit ticktime : 
    // The framework tick-timer resolution
    // Argument unsigned maxTM : 
    // The max number of timeouts that can be waiting simultaneously
    // Argument bool isRealTimeModel : 
    // The framework tick-timer mode (real time when true or simulated otherwise)
    //## operation initialize(int,char*,unsigned ,const char * ,OxfTimeUnit,unsigned ,bool) 
    static bool initialize(int aomArg(numProgArgs) = 0, char** aomArg(progArgs) = NULL, unsigned aomArg(defaultPort) = 
    0, const char * aomArg(defaultHost) = NULL, OxfTimeUnit ticktime = OMTimerManagerDefaults::defaultTicktime, 
    unsigned maxTM = OMTimerManagerDefaults::defaultMaxTM, bool isRealTimeModel = true);
    
    // getter & setter for the framework memory manager
    // set the framework memory manager, allowed only before any memory allocation request was made
    // Argument IOxfMemoryAllocator* memoryManager : 
    // The plug-in memory manager
    //## operation setMemoryManager(IOxfMemoryAllocator) 
    static bool setMemoryManager(IOxfMemoryAllocator* memoryManager);
    
    // setting of the  default active class is allowed only before OXF::init() is called.
    // Argument IOxfActive* t : 
    // The alternative default active class
    //## operation setTheDefaultActiveClass(IOxfActive) 
    static bool setTheDefaultActiveClass(IOxfActive* t);
    
    // setting the low level timers factory is allowed only before OXF::init() is called.
    // it is allowed to be set only once of the entire life-time of the application
    // Argument const IOxfTickTimerFactory* theFactory : 
    // The tick-timer factory
    //## operation setTheTickTimerFactory(IOxfTickTimerFactory) 
    static bool setTheTickTimerFactory(const IOxfTickTimerFactory* theFactory);
    
    // Start the framework default event loop
    // Argument bool doFork : 
    // The fork flag
    // When false the framework is expected to use the thread that the framework was initialized on.
    // Otherwise a new RTOS thread is created.
    //## operation start(bool) 
    static void start(bool doFork = false);
    
    // Activate the global system support in explicit reactive instances deletion (delete <instance> instead of 
    // <instance>->terminate())
    //## operation supportExplicitReactiveDeletion() 
    static void supportExplicitReactiveDeletion();


////    Additional operations    ////
public :
    
    //## auto_generated 
    static bool getManagedTimeoutCanceling();
    
    //## auto_generated 
    static void setManagedTimeoutCanceling(bool p_managedTimeoutCanceling);
    
    //## auto_generated 
    inline static bool getRhp5CompatibleAPI();
    
    //## auto_generated 
    inline static void setRhp5CompatibleAPI(bool p_rhp5CompatibleAPI);
    
    //## auto_generated 
    static IOxfActive* getTheDefaultActiveClass();
    
    //## auto_generated 
    static IOxfMemoryAllocator* getMemoryManager();
    
    //## auto_generated 
    static const IOxfTickTimerFactory* getTheTickTimerFactory();


////    Attributes    ////
private :
    
    // When this flag is true, the framework is responsible for timeout cancellation (via the OMTimerManager) 
    // otherwise each reactive instance is responsible for its own timeouts cancellation.
    static bool managedTimeoutCanceling;		//## attribute managedTimeoutCanceling 
    
    // This flag specifies that the framework should call methods using the Rhapsody 5.X implementation signatures to 
    // support customization of the Core implementation classes.
    static bool rhp5CompatibleAPI;		//## attribute rhp5CompatibleAPI 
    

////    Relations and components    ////
private :
    
    // The framework default active class (the default event loop)
    static IOxfActive* theDefaultActiveClass;		//## link theDefaultActiveClass 
    
    
    // The framework memory manager
    static IOxfMemoryAllocator* theMemoryManager;		//## link theMemoryManager 
    
    
    // A low-level timer factory -
    // if the user set the factory, these timers will be used instead of the OSAL timers
    static const IOxfTickTimerFactory* theTickTimerFactory;		//## link theTickTimerFactory 
    


};
//---------------------------------------------------------------------------- 
// inline operations for OXF
//---------------------------------------------------------------------------- 

inline bool OXF::getRhp5CompatibleAPI() {
    return rhp5CompatibleAPI;
}

inline void OXF::setRhp5CompatibleAPI(bool p_rhp5CompatibleAPI) {
    rhp5CompatibleAPI = p_rhp5CompatibleAPI;
}



#endif  
//
//! Log: $Log: oxf.h $
//! Log: Revision 1.75  2007/04/06 07:08:21  ilgiga
//! Log: bug fix 98191
//


