//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMThread
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/omthread.h $
//!	File version	: $Revision: 1.93 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:16 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef omthread_H 

#define omthread_H 

#include "OXFEvents.h"
#include "IOxfActive.h"
#include "IOxfEvent.h"
#include "OMEventQueue.h"
#include "os.h"
#include "omprotected.h"

//----------------------------------------------------------------------------
// omthread.h                                                                  
//----------------------------------------------------------------------------

class AnimServices;
class IOxfTimeout;
class OMEvent;
template <class  Concept> class OMIterator;
class OMMainThread;
class OMOS;
class OMOSEventGenerationParams;
class OMReactive;
class OMThreadManager;
class OMTimeout;
class OMTimerManager;
class OXF;

//## package Design::oxf::Core::CoreImplementation 


// The base IOxfActive implementation 
//## class OMThread 
class RP_FRAMEWORK_DLL OMThread : public IOxfActive {


////    Constructors and destructors    ////
public :
    
    // Initialize the  thread
    // Argument const char* const name : 
    // The RTOS thread name
    // Argument long priority : 
    // The RTOS thread priority
    // Argument long stackSize : 
    // The RTOS thread stack size
    // Argument long messageQueueSize : 
    // The message queue size (number of messages)
    // Argument bool dynamicMessageQueue : 
    // When true the message queue should grow when it is full
    //## operation OMThread(char*,long,long,long,bool) 
    OMThread(const char* const name = 0, long priority = OMOSThread::DefaultThreadPriority, long stackSize = 
    OMOSThread::DefaultStackSize
, long 
    messageQueueSize = OMOSThread::DefaultMessageQueueSize, bool dynamicMessageQueue = true);
    
    // Initialize the  thread
    // Argument bool wrapThread : 
    // When true the thread should wrap the current RTOS thread instead of spawning a new one.
    //## operation OMThread(bool) 
    OMThread(bool wrapThread);
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~OMThread() 
    ~OMThread();


////    Operations    ////
public :
    
    // Check if the thread can be deleted
    //## operation allowDeleteInThreadsCleanup() 
    virtual bool allowDeleteInThreadsCleanup();
    
    // cancel event
    // Argument OMEvent* ev : 
    // The event to cancel
    //## operation cancelEvent(OMEvent) 
    
    //#[ ignore 
    #ifndef OM_DISABLE_DIRECT_REACTIVE_DELETION
    //#]
    virtual void cancelEvent(OMEvent* ev);
    //#[ ignore 
    
    #endif //!OM_DISABLE_DIRECT_REACTIVE_DELETION
    //#]
    
    
    // cancel all events targeted for destination			
    // Argument OMReactive* destination : 
    // The reactive instance that all its pending events should be canceled
    //## operation cancelEvents(OMReactive) 
    
    //#[ ignore 
    #ifndef OM_DISABLE_DIRECT_REACTIVE_DELETION
    //#]
    virtual void cancelEvents(OMReactive* destination);
    //#[ ignore 
    
    #endif //!OM_DISABLE_DIRECT_REACTIVE_DELETION
    //#]
    
    
    // Cancel an invent event in the queue.
    // This operation requires an ability to iterate over the events waiting in the queue.
    // Argument IOxfEvent* ev : 
    // An event to cancel
    //## operation cancelPendingEvent(IOxfEvent) 
    
    //#[ ignore 
    #ifndef OM_DISABLE_DIRECT_REACTIVE_DELETION
    //#]
    virtual void cancelPendingEvent(IOxfEvent* ev);
    //#[ ignore 
    
    #endif //!OM_DISABLE_DIRECT_REACTIVE_DELETION
    //#]
    
    
    // Cancel all events targeted for destination.
    // This operation requires an ability to iterate over the events waiting in the queue.	
    // Argument IOxfReactive* destination : 
    // A reactive instance to cancel all its pending events
    //## operation cancelPendingEvents(IOxfReactive) 
    
    //#[ ignore 
    #ifndef OM_DISABLE_DIRECT_REACTIVE_DELETION
    //#]
    virtual void cancelPendingEvents(IOxfReactive* destination);
    //#[ ignore 
    
    #endif //!OM_DISABLE_DIRECT_REACTIVE_DELETION
    //#]
    
    
    // Destroy all the active threads
    //## operation cleanupAllThreads() 
    static OMThread* cleanupAllThreads();
    
    // Destroy the active instance.
    //## operation destroyThread() 
    virtual void destroyThread();
    
    // end the active instance event dispatching and destroy the instance.
    //## operation endDispatching() 
    void endDispatching();
    
    // Get the thread event queue
    //## operation getEventQueue() const 
    const OMEventQueue* getEventQueue() const;
    
    // Get the thread guard
    //## operation getGuard() const 
    const OMProtected& getGuard() const;
    
    // asking for a callback to end my os thread
    // onExecuteThread = true: I will kill my own thread
    // onExecuteThread = false: someone else will kill my thread
    // Argument OMOSThread::EndCallBack* clb_p : 
    // The termination callback function
    // Argument void ** arg1_p : 
    // An argument to the termination function
    // Argument bool onExecuteThread : 
    // The context (this thread vs. other thread)
    //## operation getOSThreadEndClb(EndCallBack,void *,bool) const 
    void getOSThreadEndClb(OMOSThread::EndCallBack* clb_p, void ** arg1_p, bool onExecuteThread = true) const;
    
    // get the OS thread handle
    //## operation getOsHandle() const 
    void * getOsHandle() const;
    
    // Get the RTOS thread handle
    // Argument void *& osHandle : 
    // The RTOS thread handle
    //## operation getOsHandle(void *) const 
    void * getOsHandle(void *& osHandle) const;
    
    // Guard API
    //## operation lock() const 
    void lock() const;
    
    // Get the event queue of this thread
    //## operation omGetEventQueue() const 
    virtual const OMEventQueue* omGetEventQueue() const;
    
    // Queue the event for later processing
    // Argument IOxfEvent* ev : 
    // the event to queue
    // Argument const IOxfEventGenerationParams& params : 
    // Queuing parameters
    //## operation queue(IOxfEvent,IOxfEventGenerationParams) 
    bool queue(IOxfEvent* ev, const IOxfEventGenerationParams& params);
    
    // Queue the event for later processing
    // Argument OMEvent* ev : 
    // The event to queue
    // Argument bool fromISR : 
    // When true the queuing is done in the context of an ISR
    //## operation queueEvent(OMEvent,bool) 
    virtual bool queueEvent(OMEvent* ev, bool fromISR = false);
    
    // resume the thread
    //## operation resume() 
    void resume();
    
    // Set timeout
    // Argument OxfTimeUnit deltaTime : 
    // The time until the timeout will expire
    // Argument short id : 
    // The timeout id
    // Argument OMReactive* instance : 
    // The timeout client
    // Argument const OMHandle* state : 
    // The timeout client state (for design level debugging)
    //## operation schedTm(OxfTimeUnit,short,OMReactive,OMHandle) 
    virtual void schedTm(OxfTimeUnit deltaTime, short id, OMReactive* instance, const OMHandle* state = 0);
    
    // set the os thread in DTOR flag
    // Argument bool b : 
    // The new value
    //## operation setEndOSThreadInDtor(bool) 
    inline void setEndOSThreadInDtor(bool b) {
        //#[ operation setEndOSThreadInDtor(bool) 
        if (osThread) {
        	osThread->setEndOSThreadInDtor(b);
        }
        //#]
    }
    
    
    // set the thread priority
    // Argument int pr : 
    // The new priority
    //## operation setPriority(int) 
    void setPriority(int pr);
    
    // backward compatibility
    // Argument int doFork : 
    // When the value is other than 0, activate the event loop on a new thread.
    //## operation start(int) 
    virtual void start(int doFork = 0);
    
    // start the thread & the event loop - 
    // 
    // IMPORTANT: OMThread ignore start parameter!! 
    // 	the parameter should be checked only in default application threads (OMMainThread)
    // 
    // when creating an alternative default thread - 
    // 	when doFork is set to false, the framework is expected to use the OS main thread.
    // 	when doFork is set to true is should create a new thread.
    // 					
    // Argument bool /**/ : 
    // ignored
    //## operation startDispatching(bool) 
    virtual void startDispatching(bool /**/ = false);
    
    // Stop the execution of all the framework threads to enable unload of framework related modules (used for COM 
    // applications support)
    // Argument const OMThread* skipme : 
    // The thread that initiate the call (should not be stopped in this call)
    //## operation stopAllThreads(OMThread) 
    static OMThread* stopAllThreads(const OMThread* skipme);
    
    // suspend the thread
    //## operation suspend() 
    void suspend();
    
    // Unlock the thread guard
    //## operation unlock() const 
    void unlock() const;
    
    // Remove timeout
    // Argument IOxfEvent::ID id : 
    // The timeout id
    // Argument OMReactive* c : 
    // The timeout client
    //## operation unschedTm(ID,OMReactive) 
    virtual void unschedTm(IOxfEvent::ID id, OMReactive* c);

protected :
    
    // cleanup - hook to allow cleanup of a thread without calling the DTOR
    // this method is needed to allow cleanup without destruction of the v-table
    //## operation cleanupThread() 
    virtual void cleanupThread();
    
    // dispatch the specified event to its destination
    // Argument IOxfEvent* ev : 
    // The event to dispatch
    //## operation dispatch(IOxfEvent) 
    IOxfReactive::TakeEventStatus dispatch(IOxfEvent* ev);
    
    // task entry method - calls execute
    // Argument void * me : 
    // This thread - passed via the RTOS thread entry point
    //## operation doExecute(void *) 
    static void doExecute(void * me);
    
    // The thread event loop
    //## operation execute() 
    virtual OMReactive* execute();
    
    // Set the OSAL thread
    // Argument OMOSThread* thread : 
    // The OSAL thread
    //## operation setOsThread(OMOSThread*) 
    void setOsThread(OMOSThread* thread);

private :
    
    // cleanup - called from the DTOR and from cleanupThread()
    //## operation _cleanupThread() 
    void _cleanupThread();
    
    // initialization
    // Argument bool wrapThread : 
    // When true the thread should wrap the current RTOS thread instead of spawning a new one.
    // Argument const char* name : 
    // The RTOS thread name
    // Argument long stackSize : 
    // The RTOS thread stack size
    // Argument long messageQueueSize : 
    // The RTOS thread message queue size (number of messages)
    // Argument bool dynamicMessageQueue : 
    // When true the message queue should grow when it is full
    //## operation _initializeOMThread(bool,char*,long,long,bool) 
    void _initializeOMThread(bool wrapThread, const char* name = 0, long stackSize = OMOSThread::DefaultStackSize, long
     messageQueueSize = OMOSThread::DefaultMessageQueueSize, bool dynamicMessageQueue = true);
    
    // Check if the event is canceled
    // Argument const IOxfEvent* ev : 
    // The context event
    //## operation isCanceled(IOxfEvent) const 
    bool isCanceled(const IOxfEvent* ev) const;
    
    // Check if the event is a framework control event
    // Argument const IOxfEvent* ev : 
    // The context event
    //## operation isControlEvent(IOxfEvent) const 
    bool isControlEvent(const IOxfEvent* ev) const;
    
    // Check if the event should be dispatched
    // Argument const IOxfEvent* ev : 
    // The context event
    //## operation shouldDispatch(IOxfEvent) const 
    bool shouldDispatch(const IOxfEvent* ev) const;


////    Additional operations    ////
public :
    
    //## auto_generated 
    bool getDeletionAllowed() const;
    
    //## auto_generated 
    void setDeletionAllowed(bool p_deletionAllowed);
    
    //## auto_generated 
    bool shouldGuardThread() const;
    
    //## auto_generated 
    void setToGuardThread(bool p_toGuardThread);
    
    //## auto_generated 
    OMOSThread* getOsThread() const;


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
private :
    
    // Indicator that prevents deletion of statically allocated objects.
    bool deletionAllowed;		//## attribute deletionAllowed 
    
    // activate guard flag
    bool toGuardThread;		//## attribute toGuardThread 
    
    // The event loop state, when the value becomes false the event loop is terminated and the thread is destroyed.
    bool processing;		//## attribute processing 
    
public :
    
    // This flag indicate that the application is terminating.
    static bool endOfProcess;		//## attribute endOfProcess 
    
private :
    
    // The event loop state, when the value becomes false the event loop will ignore all the events in the queue until 
    // the OMEndThreadEvent is received.
    bool dispatching;		//## attribute dispatching 
    
    // The thread termination self event
    OMEndThreadEvent endThreadEvent;		//## attribute endThreadEvent 
    
    // Since reactive instances are performing second dispatching of the termination event the active object must 
    // follow the same policy to enable reactive parts to finalize their self-destruction.
    // This attribute is used for this aim.
    bool finalTermination;		//## attribute finalTermination 
    

////    Relations and components    ////
private :
    
    // The event dispatching guard - prevents mutual exclusion between the event dispatching and instance deletion.
    OMProtected dispatchingGuard;		//## classInstance dispatchingGuard 
    
    
    // The thread event queue
    OMEventQueue eventQueue;		//## classInstance eventQueue 
    
    
    OMOSThread* osThread;		//## link osThread 
    


};

//#[ ignore 

// Include the declaration of OMMainThread
// for backward compatibility
#include "OMMainThread.h"
//#]



#endif  
//
//! Log: $Log: omthread.h $
//! Log: Revision 1.93  2007/04/06 07:08:16  ilgiga
//! Log: bug fix 98191
//


