//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMThread
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/omthread.cpp $
//!	File version	: $Revision: 1.151 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:16 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: omthread.cpp 1.151 2007/04/06 07:08:16 ilgiga Exp $";
#endif
//#]

#include "omthread.h"

//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
#include <aom/AnimServices.h>

//#[ ignore 
#endif //_OMINSTRUMENT
//#]
#include "OXFGuardMacros.h"
#include "IOxfTimeout.h"
#include "OMEvent.h"
#include "OMIterator.h"
#include "OMMainThread.h"
#include "os.h"
#include "OMOSEventGenerationParams.h"
#include "omreactive.h"
#include "OMThreadManager.h"
#include "OMTimeout.h"
#include "OMTimerManager.h"
#include "oxf.h"

//----------------------------------------------------------------------------
// omthread.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Core::CoreImplementation 

//## class OMThread 


// Static class member attribute
bool OMThread::endOfProcess = false;

OMThread::OMThread(const char* const name, long priority, long stackSize, long messageQueueSize, bool 
dynamicMessageQueue) : deletionAllowed(true) ,toGuardThread(false) ,processing(true) ,dispatching(true) ,
finalTermination(false) {
    //#[ operation OMThread(char*,long,long,long,bool) 
    _initializeOMThread(false, name, stackSize, messageQueueSize, dynamicMessageQueue);
    setPriority(priority);
    //#]
}

OMThread::OMThread(bool wrapThread) : deletionAllowed(true) ,toGuardThread(false) ,processing(true) ,dispatching(true)
 ,finalTermination(false) {
    //#[ operation OMThread(bool) 
    _initializeOMThread(wrapThread);
    //#]
}

OMThread::~OMThread() {
    //#[ operation ~OMThread() 
    _cleanupThread();
    //#]
    cleanUpRelations();
}

void OMThread::_cleanupThread() {
    //#[ operation _cleanupThread() 
    OMThreadManager::instance().deregisterThread(this);
    
    #ifdef _OMINSTRUMENT
    AnimServices::notifyThreadDestroyed(getOsHandle());
    #endif
    
    if (osThread && !osThread->exeOnMyThread())
    {
    	// The thread running the destructor is not my 'thread'
    	// so we can safely end it, thereby avoiding interference in the deletion agenda
    	setEndOSThreadInDtor(true);
    	delete osThread;	// deletes the object representing the OS thread (i.e. release resources)
    	osThread = 0;
    }
    
    eventQueue.cleanup();
    
    if (toGuardThread)
    {
    	// toGuard should be set to true by the application class, if necessary
    	END_THREAD_GUARDED_SECTION
    }
    // For selfterminated thread we should cleanup it here
    dispatchingGuard.cleanupMutex();
    
    if ((osThread != 0) && (osThread->exeOnMyThread()))
    {
    	// here we should delete the mutex of this' OMProtected
    	// otherwise, the code for unlock the mutex will not be executed 
    	// since the thread is just to be deleted
    	 unlock();
    
    	// Deletes the object representing the OS thread (i.e. release resources),
    	// really ending it depends on the thread itself.
    	// Depends what is the cause of destruction:
    	// is it an event that reaches a temriante connector, which is the recommended approach (see doExecute())
    	// or different path like a trigger operation reaching a terminate connector or even a 'delete this'....
    	delete osThread;
    	osThread = 0;
    }
    //#]
}

void OMThread::_initializeOMThread(bool wrapThread, const char* name, long stackSize, long messageQueueSize, bool 
dynamicMessageQueue) {
    //#[ operation _initializeOMThread(bool,char*,long,long,bool) 
    OMThreadManager::instance().registerThread(this);
    toGuardThread = false; // the application class should set it to true, if necessary
    if (!wrapThread)
    {
    	// Creating a thread of control
    	osThread = OMOSFactory::instance()->createOMOSThread(doExecute, this, name, stackSize); 
    }
    else
    {
    	// When we wrap the thread WE ARE SURE that we are wrapping the
    	// current thread so we can ask about its identifier and then
    	// create the OSwrapper thread.
    	void* threadOsHandle = OMOSFactory::instance()->getCurrentThreadHandle();
    	osThread = OMOSFactory::instance()->createOMOSWrapperThread(threadOsHandle);
    }
    
    // Create the event queue
    eventQueue.init(messageQueueSize, dynamicMessageQueue) ;
    eventQueue.getOsQueue()->setOwnerProcess(osThread->getOsHandle());
    
    #ifdef _OMINSTRUMENT
    AnimServices::notifyThreadCreated(this, osThread->getOsHandle());
    #endif
    //#]
}

bool OMThread::allowDeleteInThreadsCleanup() {
    //#[ operation allowDeleteInThreadsCleanup() 
    return deletionAllowed;
    //#]
}


//#[ ignore 
#ifndef OM_DISABLE_DIRECT_REACTIVE_DELETION
//#]
void OMThread::cancelEvent(OMEvent* ev) {
    //#[ operation cancelEvent(OMEvent) 
    IOxfEvent* e = ev;
    cancelPendingEvent(e);
    //#]
}

//#[ ignore 

#endif //!OM_DISABLE_DIRECT_REACTIVE_DELETION
//#]


//#[ ignore 
#ifndef OM_DISABLE_DIRECT_REACTIVE_DELETION
//#]
void OMThread::cancelEvents(OMReactive* destination) {
    //#[ operation cancelEvents(OMReactive) 
    IOxfReactive* dest = destination;
    cancelPendingEvents(dest);
    //#]
}

//#[ ignore 

#endif //!OM_DISABLE_DIRECT_REACTIVE_DELETION
//#]


//#[ ignore 
#ifndef OM_DISABLE_DIRECT_REACTIVE_DELETION
//#]
void OMThread::cancelPendingEvent(IOxfEvent* ev) {
    //#[ operation cancelPendingEvent(IOxfEvent) 
    #ifdef _OMINSTRUMENT
    // notify the user of this cancellation
    AnimServices::notifyEventCancelled(getOsHandle(), ev);
    #endif
    
    // cancel an event means marking it as cancelled
    ev->setId(OMCancelledEventId);
    //#]
}

//#[ ignore 

#endif //!OM_DISABLE_DIRECT_REACTIVE_DELETION
//#]


//#[ ignore 
#ifndef OM_DISABLE_DIRECT_REACTIVE_DELETION
//#]
void OMThread::cancelPendingEvents(IOxfReactive* destination) {
    //#[ operation cancelPendingEvents(IOxfReactive) 
    if (OXF::getManagedTimeoutCanceling())
    {
    	// compatibility mode
    	// cancel any timeouts that are targeted to destination
    	OMTimerManager* sysTimer = OMTimerManager::instance();
    	if (sysTimer)
    	{
    		sysTimer->unschedTm(OMAnyEventId ,destination);
    	}
    }
    // cancel existing events that are targeted to destination
    // NOTE: There is not explicit care for making the following code guarded,
    // so based on the underlying implementation of eventQueue,
    // messageList may not reflect the most updated content of the eventQueue
    OMList<IOxfEvent*> messageList;
    eventQueue.getMessageList(messageList); // not guarded
    
    OMIterator<IOxfEvent*> iter(messageList);
    for ( ; (*iter) != 0; ++iter)
    {
    	IOxfEvent* ev = (*iter);
    	if (ev->getDestination() == destination)
    	{
    		if (OXF::getRhp5CompatibleAPI())
    		{
    			// compatibility mode
    			cancelEvent(static_cast<OMEvent*>(ev));
    		}
    		else
    		{
    			// normal mode
    			cancelPendingEvent(ev);
    		}
    	}
    }
    //#]
}

//#[ ignore 

#endif //!OM_DISABLE_DIRECT_REACTIVE_DELETION
//#]

OMThread* OMThread::cleanupAllThreads() {
    //#[ operation cleanupAllThreads() 
    return OMThreadManager::instance().cleanupAllThreads();
    //#]
}

void OMThread::cleanupThread() {
    //#[ operation cleanupThread() 
    _cleanupThread();
    //#]
}

void OMThread::destroyThread() {
    //#[ operation destroyThread() 
    if (deletionAllowed)
    {
    	delete this;
    }
    else
    {
    	_cleanupThread();
    }
    //#]
}

IOxfReactive::TakeEventStatus OMThread::dispatch(IOxfEvent* ev) {
    //#[ operation dispatch(IOxfEvent) 
    IOxfReactive::TakeEventStatus result = IOxfReactive::eventNotConsumed;
    bool destroyEvent = true;
    if (shouldDispatch(ev))
    {
    	// do not try to destroy the reactive termination event
    	// since it is part of the reactive object that performs 
    	// self destruction
    	destroyEvent = !isControlEvent(ev);
    	
    	IOxfReactive* dest = ev->getDestination();
    	if (dest != 0)
    	{
    		if (!OXF::getRhp5CompatibleAPI())
    		{
    			// normal mode
    			result = dest->handleEvent(ev);
    		}
    		else
    		{
    			// compatibility mode
    			OMEvent* e = static_cast<OMEvent*>(ev);
    			OMReactive* r = static_cast<OMReactive*>(dest);
    			result = r->takeEvent(e);
    		}
    	}
    }
    if (destroyEvent)
    {
    	if (!OXF::getRhp5CompatibleAPI())
    	{
    		// normal mode
    		ev->destroy();
    	}
    	else
    	{
    		// compatibility mode
    		OMEvent* e = static_cast<OMEvent*>(ev);
    		e->Delete();
    	}
    }
    return result;
    //#]
}

void OMThread::doExecute(void * me) {
    //#[ operation doExecute(void *) 
    // Now do some real work
    OMThread* theThread = static_cast<OMThread*>(me);
    // start the event loop
    /*OMReactive* theReactive = */ (void) theThread->execute();
    // the event loop ends
    OMOSThread::EndCallBack theOSThreadEnderClb;
    void * arg1;
    // get a callback to end the thread
    theThread->getOSThreadEndClb(&theOSThreadEnderClb,&arg1);
    theThread->setEndOSThreadInDtor(false);
    
    // do not really end the os thread because we 
    // are executing on this thread and if do
    // we are going to leak resources
    theThread->destroyThread();
    
    if (theOSThreadEnderClb != 0) {
    	// now end the os thread
    	(*theOSThreadEnderClb)(arg1);
    }
    //#]
}

void OMThread::endDispatching() {
    //#[ operation endDispatching() 
    // stop dispatching of events
    dispatching = false;
    // the dummy event will wakeup thread if it is waiting on the queue
    OMOSEventGenerationParams p;
    (void)queue(&endThreadEvent, p);
    //#]
}

OMReactive* OMThread::execute() {
    //#[ operation execute() 
    OMTimerManager* sysTimer = OMTimerManager::instance();
    
    #ifdef _OMINSTRUMENT
    AnimServices::resetCallStack(getOsHandle());
    #endif
    
    while (processing)
    {
    	if (sysTimer)
    	{
    		sysTimer->incNonIdleThreadCounter();
    	}
    #ifdef _OMINSTRUMENT
    	bool shouldNotify = true; // Ensure we do not report again
    	// after "dummy" or cancelled events
    #endif
    	
    	bool thereAreEventsToConsume = true;
    	while (thereAreEventsToConsume)
    	{
    		// process all the events in the queue
    		
    #ifdef _OMINSTRUMENT
    		// store the shouldNotify in order to reset it in case of anim wakeup event
    		bool lastShouldNotify = shouldNotify;
    		if (!eventQueue.isEmpty() && 
    		shouldNotify && 
    		!OMThread::endOfProcess)
    		{
    			// notifyEventStep() supports the "go event" command
    			// The semantics of go event is to stop before extracting the first event from the queue -
    			// and then continue until the queue is empty before stopping again
    			AnimServices::notifyEventStep(getOsHandle());
    			shouldNotify = false;
    		}
    #endif // _OMINSTRUMENT
    
    		if (toGuardThread)
    		{
    			// toGuard should be set to true by the application class, if necessary
    			START_THREAD_GUARDED_SECTION 
    		}
    
    #ifdef _OMINSTRUMENT
    		AnimServices::notifyEventGetBegin(getOsHandle());
    #endif // _OMINSTRUMENT
    
    		// Actually dispatch the event
    		IOxfEvent* ev = eventQueue.get();
    
    #ifdef _OMINSTRUMENT
    		IOxfEvent* animEv = ev;
    		if (animEv != 0 &&
    			animEv->getId() == OMAnimWakeupEventId)
    		{
    			// animation should ignore the wakeup token
    			animEv = 0;
    			// reset the shouldNotify state
    			shouldNotify = lastShouldNotify;
    		}
    		AnimServices::notifyEventGetEnd(getOsHandle(), animEv);
    #endif // _OMINSTRUMENT
    
    		if (ev == 0)
    		{
    			thereAreEventsToConsume = false;
    		}
    		else
    		{
    			if (ev->getId() == OMEndThreadEventId)
    			{
    				if (finalTermination)
    				{
    					// stop the event loop
    					processing = false;
    					break;
    				}
    				else
    				{
    					// resend the termination event
    					finalTermination = true;
    					endDispatching();
    				}
    			}
    		
    			IOxfReactive::TakeEventStatus result = IOxfReactive::eventConsumed;
    			IOxfReactive* dest = ev->getDestination();
    #ifdef _OMINSTRUMENT
    			if (!isCanceled(ev) &&
    				ev->getId() != OMAnimWakeupEventId)
    			{
    				// destination still exists
    				shouldNotify = true;
    			}
    #endif
    			result = dispatch(ev);
    			ev = 0;
    
    			if (result == IOxfReactive::instanceReachTerminate)
    			{
    				if (dest)
    				{
    					dest->destroy();
    				}
    			}
    		}
    
    		if (toGuardThread)
    		{
    			// toGuard should be set to true by the application class, if necessary
    			END_THREAD_GUARDED_SECTION
    		}
    	}
    	if (processing)
    	{
    		if (sysTimer)
    		{
    			sysTimer->decNonIdleThreadCounter();
    		}
    
    #ifdef _OMINSTRUMENT
    		// Entering idle state 
    		// If should stop on idle -- then stop
    		// else become idle 
    		// Note: if should stop on idle you never realy go idle
    		if (AnimServices::shouldNotifyIdle(getOsHandle()))
    		{
    			AnimServices::notifyIdle(getOsHandle());
    		}
    		else
    		{
    			eventQueue.pend();
    			AnimServices::notifyReady(getOsHandle());
    		}
    #else
    		eventQueue.pend();
    #endif
    
    	}
    }
    // the return type is maintained for backward compatibility
    return 0;
    //#]
}

const OMEventQueue* OMThread::getEventQueue() const {
    //#[ operation getEventQueue() const 
    // return the queue
    return &eventQueue;
    //#]
}

const OMProtected& OMThread::getGuard() const {
    //#[ operation getGuard() const 
    return dispatchingGuard;
    //#]
}

void OMThread::getOSThreadEndClb(OMOSThread::EndCallBack* clb_p, void ** arg1_p, bool onExecuteThread) const {
    //#[ operation getOSThreadEndClb(EndCallBack,void *,bool) const 
    // propagate the request to the object representing the real os thread
    if (osThread) {
    	osThread->getThreadEndClbk(clb_p,arg1_p,onExecuteThread);
    }
    //#]
}

void * OMThread::getOsHandle() const {
    //#[ operation getOsHandle() const 
    return osThread->getOsHandle();
    //#]
}

void * OMThread::getOsHandle(void *& osHandle) const {
    //#[ operation getOsHandle(void *) const 
    return osThread->getOsHandle(osHandle);
    //#]
}

bool OMThread::isCanceled(const IOxfEvent* ev) const {
    //#[ operation isCanceled(IOxfEvent) const 
    bool canceled = false;
    if (ev != 0)
    {
    	if ((ev->getId() == OMTimeoutEventId) && 
    		static_cast<const IOxfTimeout*>(ev)->isCanceled())
    	{
    		canceled = true;
    	}
    	// support direct reactive deletion
    	else if (ev->getId() == OMCancelledEventId)
    	{
    		canceled = true;
    	}
    }
    return canceled;
    //#]
}

bool OMThread::isControlEvent(const IOxfEvent* ev) const {
    //#[ operation isControlEvent(IOxfEvent) const 
    bool res = false;
    if (ev != 0)
    {
    	res = (ev->isTypeOf(OMEndThreadEventId) ||
    		ev->isTypeOf(OMReactiveTerminationEventId));
    }
    return res;
    //#]
}

void OMThread::lock() const {
    //#[ operation lock() const 
    dispatchingGuard.lock();
    //#]
}

const OMEventQueue* OMThread::omGetEventQueue() const {
    //#[ operation omGetEventQueue() const 
    return getEventQueue();
    //#]
}

bool OMThread::queue(IOxfEvent* ev, const IOxfEventGenerationParams& params) {
    //#[ operation queue(IOxfEvent,IOxfEventGenerationParams) 
    #ifdef _OMINSTRUMENT
    bool shouldNotify = (!params.getFromISR());
    if (shouldNotify)
    {
    	AnimServices::notifyEventPutBegin(getOsHandle(), ev, eventQueue.isFull());
    }
    #endif // _OMINSTRUMENT
    
    // queue the event
    bool res = eventQueue.putMessage(ev, params);
    
    #ifdef _OMINSTRUMENT
    if (shouldNotify)
    {
    	AnimServices::notifyEventPutEnd(getOsHandle(), ev, res);
    }
    #endif // _OMINSTRUMENT
    
    return res;
    //#]
}

bool OMThread::queueEvent(OMEvent* ev, bool fromISR) {
    //#[ operation queueEvent(OMEvent,bool) 
    bool res = false;
    if (fromISR)
    {
    	res = queue(ev, OMReactive::isrParams);
    }
    else
    {
    	OMOSEventGenerationParams params(false);
    	res = queue(ev, params);
    }
    return res;
    //#]
}

void OMThread::resume() {
    //#[ operation resume() 
    osThread->resume();
    //#]
}

void OMThread::schedTm(OxfTimeUnit deltaTime, short id, OMReactive* instance, const OMHandle* state) {
    //#[ operation schedTm(OxfTimeUnit,short,OMReactive,OMHandle) 
    // Create the event
    OMTimeout* timeout = new OMTimeout(instance, deltaTime, state);
    // protect against timeout scheduling before the pool was initialized
    if (!timeout)
    {
    	return;
    }
    timeout->setTimeoutId(id);
    
    // Delegating the request to timer
    OMTimerManager* sysTimer = OMTimerManager::instance();
    if (sysTimer)
    {
    	(void) sysTimer->set(timeout); 
    }
    
    #ifdef _OMINSTRUMENT
    // notify the event queue of this
    AnimServices::notifyTimeoutSet(timeout);
    #endif
    //#]
}

void OMThread::setOsThread(OMOSThread* thread) {
    //#[ operation setOsThread(OMOSThread*) 
    osThread = thread;
    //#]
}

void OMThread::setPriority(int pr) {
    //#[ operation setPriority(int) 
    if (osThread) {
    	osThread->setPriority(pr);
    }
    //#]
}

bool OMThread::shouldDispatch(const IOxfEvent* ev) const {
    //#[ operation shouldDispatch(IOxfEvent) const 
    bool res = false;
    if (ev != 0)
    {
    	if (!isCanceled(ev))
    	{
    		res = (dispatching || isControlEvent(ev));
    	}
    }
    return res;
    //#]
}

void OMThread::start(int doFork) {
    //#[ operation start(int) 
    bool fork = (doFork != 0);
    startDispatching(fork);
    //#]
}

void OMThread::startDispatching(bool /**/) {
    //#[ operation startDispatching(bool) 
    if (osThread) {
    	osThread->start();
    }
    //#]
}

OMThread* OMThread::stopAllThreads(const OMThread* skipme) {
    //#[ operation stopAllThreads(OMThread) 
    return OMThreadManager::instance().stopAllThreads(skipme);
    //#]
}

void OMThread::suspend() {
    //#[ operation suspend() 
    if (osThread) {
    	osThread->suspend();
    }
    //#]
}

void OMThread::unlock() const {
    //#[ operation unlock() const 
    dispatchingGuard.unlock();
    //#]
}

void OMThread::unschedTm(IOxfEvent::ID id, OMReactive* c) {
    //#[ operation unschedTm(ID,OMReactive) 
    OMTimerManager* sysTimer = OMTimerManager::instance();
    if (sysTimer) {
    	sysTimer->unschedTm(id,c);
    }
    //#]
}

bool OMThread::getDeletionAllowed() const {
    return deletionAllowed;
}

void OMThread::setDeletionAllowed(bool p_deletionAllowed) {
    deletionAllowed = p_deletionAllowed;
}

bool OMThread::shouldGuardThread() const {
    return toGuardThread;
}

void OMThread::setToGuardThread(bool p_toGuardThread) {
    toGuardThread = p_toGuardThread;
}

OMOSThread* OMThread::getOsThread() const {
    return osThread;
}

void OMThread::cleanUpRelations() {
    if(osThread != 0)
        {
            osThread = 0;
        }
}



//
//! Log: $Log: omthread.cpp $
//! Log: Revision 1.151  2007/04/06 07:08:16  ilgiga
//! Log: bug fix 98191
//


