//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: TimeManagement
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OXFTimeManagement.cpp $
//!	File version	: $Revision: 1.20 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:05 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: OXFTimeManagement.cpp 1.20 2007/04/06 07:08:05 ilgiga Exp $";
#endif
//#]

#include "OXFTimeManagement.h"
#include "OXFEvents.h"
#include "IOxfTimeout.h"
#include "OMDelay.h"
#include "OMTimeout.h"
#include "OMTimerManager.h"
#include "OMTimerManagerDefaults.h"
#include "oxf.h"

//----------------------------------------------------------------------------
// OXFTimeManagement.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Time::TimeManagement 



//## operation operator <(IOxfTimeout,IOxfTimeout) 
bool operator <(const IOxfTimeout& t1, const IOxfTimeout& t2) {
    //#[ operation operator <(IOxfTimeout,IOxfTimeout) 
    return (t1.getDueTime() < t2.getDueTime());
    //#]
}

//## operation operator ==(IOxfTimeout,IOxfTimeout) 
bool operator ==(const IOxfTimeout& t1, const IOxfTimeout& t2) {
    //#[ operation operator ==(IOxfTimeout,IOxfTimeout) 
    bool res = false;
    if (!OXF::getManagedTimeoutCanceling())
    {
    	// normal mode
    	if (t1.isCanceled() && t2.isCanceled())
    	{
    		res = true;
    	}
    	else
    	{
    		res = (t1.getDueTime() == t2.getDueTime());
    	}
    }
    else
    {
    	// compatibility mode
    	bool matchDest = t1.getDestination() == t2.getDestination();
    	const OMTimeout& tm1 = static_cast<const OMTimeout&>(t1);
    	const OMTimeout& tm2 = static_cast<const OMTimeout&>(t2);
    	bool matchId = ((tm1.getTimeoutId() == tm2.getTimeoutId()) ||
    						 (tm1.getTimeoutId() == OMAnyEventId)		||
    						 (OMAnyEventId	== tm2.getTimeoutId()));
    	
    	res = (matchDest && matchId);
    }
    return res;
    //#]
}

//## operation operator >(IOxfTimeout,IOxfTimeout) 
bool operator >(const IOxfTimeout& t1, const IOxfTimeout& t2) {
    //#[ operation operator >(IOxfTimeout,IOxfTimeout) 
    return (t1.getDueTime() > t2.getDueTime());
    //#]
}


//
//! Log: $Log: OXFTimeManagement.cpp $
//! Log: Revision 1.20  2007/04/06 07:08:05  ilgiga
//! Log: bug fix 98191
//


