//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OXFRefManager
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OXFRefManager.cpp $
//!	File version	: $Revision: 1.18 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:03 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: OXFRefManager.cpp 1.18 2007/04/06 07:08:03 ilgiga Exp $";
#endif
//#]

#include "OXFRefManager.h"
#include "os.h"

//----------------------------------------------------------------------------
// OXFRefManager.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Guards::DllGuards 

//## class OXFRefManager 


//#[ ignore 
#ifdef FRAMEWORK_DLL
//#]


OXFRefManager::OXFRefManager() : oxfStarted(false) ,totalReferences(0) ,theMutex(NULL) {
    //#[ operation OXFRefManager() 
    theMutex = OMOSFactory::instance()->createOMOSMutex();
    //#]
}

OXFRefManager::~OXFRefManager() {
    //#[ operation ~OXFRefManager() 
    delete theMutex;
    theMutex = NULL;
    //#]
    cleanUpRelations();
}

long OXFRefManager::Decrement() {
    //#[ operation Decrement() 
    if (totalReferences > 0) {
    	--totalReferences;
    }
    return totalReferences;
    //#]
}

long OXFRefManager::Increment() {
    //#[ operation Increment() 
    return ++totalReferences;
    //#]
}

void OXFRefManager::lock() const {
    //#[ operation lock() const 
    if (theMutex) {
    	theMutex->lock();
    }
    //#]
}

void OXFRefManager::unlock() const {
    //#[ operation unlock() const 
    if (theMutex) {
    	theMutex->unlock();
    }
    //#]
}

bool OXFRefManager::getOxfStarted() const {
    return oxfStarted;
}

void OXFRefManager::setOxfStarted(bool p_oxfStarted) {
    oxfStarted = p_oxfStarted;
}

long OXFRefManager::getCount() const {
    return totalReferences;
}

void OXFRefManager::cleanUpRelations() {
    if(theMutex != 0)
        {
            theMutex = 0;
        }
}

//#[ ignore 
#else
#ifndef lint
void OXFRefManager_preventLinkWarnings(int& i)
{
	++i;
}
#endif // !lint
#endif //FRAMEWORK_DLL
//#]



//
//! Log: $Log: OXFRefManager.cpp $
//! Log: Revision 1.18  2007/04/06 07:08:03  ilgiga
//! Log: bug fix 98191
//


