//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMTimeout
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMTimeout.cpp $
//!	File version	: $Revision: 1.29 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:51 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: OMTimeout.cpp 1.29 2007/04/06 07:07:51 ilgiga Exp $";
#endif
//#]

#include "OMTimeout.h"

//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
#include <aom/AnimServices.h>

//#[ ignore 
#endif //_OMINSTRUMENT
//#]
#include "OXFEvents.h"
#include "IOxfReactive.h"
#include "omthread.h"
#include "OMTimerManager.h"
#include "oxf.h"

//----------------------------------------------------------------------------
// OMTimeout.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Core::CoreImplementation 

//## class OMTimeout 

IMPLEMENT_MEMORY_ALLOCATOR(OMTimeout, OM_DYNAMIC_POOL_INITIALIZATION_SIZE, 0, true)


OMTimeout::OMTimeout(IOxfReactive* pdest, OxfTimeUnit delay, const OMHandle* aomArg(theState)) : 
OMEvent(OMTimeoutEventId, pdest), canceled(false), delayTime(0) ,dueTime(0) ,state(0) ,timeoutId(0) {
    //#[ operation OMTimeout(IOxfReactive,OxfTimeUnit,OMHandle) 
    delayTime = delay;
    
    #ifdef _OMINSTRUMENT
    state = theState;
    AnimServices::notifyFrameworkEventCreated(this);
    #endif
    
    RESET_MEMORY_ALLOCATOR(OMTimeout)
    //#]
}

OMTimeout::OMTimeout() : 
OMEvent(OMTimeoutEventId, 0), canceled(false) ,delayTime(0) ,dueTime(0) ,state(0) ,timeoutId(0) {
    //#[ operation OMTimeout() 
    #ifdef _OMINSTRUMENT
    AnimServices::notifyFrameworkEventCreated(this);
    #endif
    
    RESET_MEMORY_ALLOCATOR(OMTimeout)
    //#]
}

OMTimeout::OMTimeout(const OMTimeout& tm) : 
OMEvent(tm), canceled(tm.canceled), delayTime(tm.delayTime), dueTime(tm.dueTime), state(tm.state), timeoutId(tm.timeoutId)
 {
    //#[ operation OMTimeout(OMTimeout) 
    RESET_MEMORY_ALLOCATOR(OMTimeout)
    //#]
}

OMTimeout::~OMTimeout() {
    //#[ operation ~OMTimeout() 
    if (!OXF::getManagedTimeoutCanceling()) {
    	// normal mode
    	// self managed timeouts - notify the destination
    	// so it can cleanup references
    	if (destination != 0) {
    		(void)destination->cancelTimeout(this);
    	}
    }
    else {
    	// compatibility mode
    	OMTimerManager* sysTimer = OMTimerManager::instance();
    	if (sysTimer) {
    		sysTimer->softUnschedTm(this);
    	}
    }
    state = 0;
    RESET_MEMORY_ALLOCATOR(OMTimeout);
    //#]
}

void OMTimeout::cancel() {
    //#[ operation cancel() 
    #ifdef _OMINSTRUMENT
    AnimServices::notifyTimeoutCancelled(this);
    #endif // _OMINSTRUMENT
    
    canceled = true;
    // prevent access to the destination on destruction
    setDestination(0);
    //#]
}

OxfTimeUnit OMTimeout::getDelay() const {
    //#[ operation getDelay() const 
    return getDelayTime();
    //#]
}

OMTimeout& OMTimeout::operator =(const OMTimeout& tm) {
    //#[ operation operator =(OMTimeout) 
    (void) OMEvent::operator=(tm);
    canceled = tm.canceled;
    delayTime = tm.delayTime;
    dueTime = tm.dueTime;
    state = tm.state;
    timeoutId = tm.timeoutId;
    RESET_MEMORY_ALLOCATOR(OMTimeout)
    return *this;
    //#]
}

bool OMTimeout::operator<(const OMTimeout& tn) const {
    //#[ operation operator<(OMTimeout) const 
    return dueTime < tn.dueTime ;
    //#]
}

bool OMTimeout::operator>(const OMTimeout& tn) const {
    //#[ operation operator>(OMTimeout) const 
    return dueTime > tn.dueTime ;
    //#]
}

void OMTimeout::setDelayTimeout() {
    //#[ operation setDelayTimeout() 
    setId(OMTimeoutDelayId);
    //#]
}

void OMTimeout::setRelativeDueTime(OxfTimeUnit now) {
    //#[ operation setRelativeDueTime(OxfTimeUnit) 
    dueTime = now + delayTime;
    //#]
}

bool OMTimeout::isCanceled() const {
    return canceled;
}

OxfTimeUnit OMTimeout::getDelayTime() const {
    return delayTime;
}

void OMTimeout::setDelayTime(OxfTimeUnit p_delayTime) {
    delayTime = p_delayTime;
}

OxfTimeUnit OMTimeout::getDueTime() const {
    return dueTime;
}

void OMTimeout::setDueTime(OxfTimeUnit p_dueTime) {
    dueTime = p_dueTime;
}

const OMHandle *OMTimeout::getState() const {
    return state;
}

void OMTimeout::setState(const OMHandle * p_state) {
    state = p_state;
}

short OMTimeout::getTimeoutId() const {
    return timeoutId;
}

void OMTimeout::setTimeoutId(short p_timeoutId) {
    timeoutId = p_timeoutId;
}



//
//! Log: $Log: OMTimeout.cpp $
//! Log: Revision 1.29  2007/04/06 07:07:51  ilgiga
//! Log: bug fix 98191
//


