//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMThreadManager
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMThreadManager.cpp $
//!	File version	: $Revision: 1.21 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:50 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: OMThreadManager.cpp 1.21 2007/04/06 07:07:50 ilgiga Exp $";
#endif
//#]

#include "OMThreadManager.h"

//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
#include <aom/AnimServices.h>

//#[ ignore 
#endif //_OMINSTRUMENT
//#]
#include "OXFEvents.h"
#include "IOxfActive.h"
#include "OMEvent.h"
#include "omthread.h"

//----------------------------------------------------------------------------
// OMThreadManager.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::ResourceManagement 

//## class OMThreadManager 



OMThreadManager::OMThreadManager() {
    //#[ operation OMThreadManager() 
    #ifdef _OMINSTRUMENT
    AnimServices::registerAnimThreadManager(this);
    #endif // _OMINSTRUMENT
    //#]
}

OMThreadManager::~OMThreadManager() {
    cleanUpRelations();
}

OMThread* OMThreadManager::cleanupAllThreads() {
    //#[ operation cleanupAllThreads() 
    #ifdef _OMINSTRUMENT
    AnimServices::notifyEndApplication(false);
    #endif // _OMINSTRUMENT
    
    OMThread::endOfProcess = true;
    OMThread* currentThread = 0;
    void* currentThreadOsHandle = OMOSFactory::instance()->getCurrentThreadHandle();
    while (!threads.isEmpty())
    {
    	// remove the first thread from the list
    	OMThread* t = threads.getFirstConcept();
    	threads.removeFirst();
    	// perform the cleanup
    	deregisterThread(t);
    	if (t->allowDeleteInThreadsCleanup() &&
    		(t !=  OMMainThread::instance(0)))
    	{
    		// not the main thread and not a thread that should not be deleted
    		if (t->getOsHandle() != currentThreadOsHandle)
    		{
    			// destroy
    			t->destroyThread();
    		}
    		else
    		{
    			// the current thread - skip
    			currentThread = t;
    		}
    	}
    }
    return currentThread;
    //#]
}

void OMThreadManager::deregisterThread(OMThread* t) {
    //#[ operation deregisterThread(OMThread) 
    #ifndef OM_NO_APPLICATION_TERMINATION_SUPPORT
    GUARD_OPERATION
    removeThreads(t);
    #endif // !OM_NO_APPLICATION_TERMINATION_SUPPORT
    //#]
}

OMThreadManager& OMThreadManager::instance() {
    //#[ operation instance() 
    static OMThreadManager theManager;
    return theManager;
    //#]
}

void OMThreadManager::registerThread(OMThread* t) {
    //#[ operation registerThread(OMThread) 
    #ifndef OM_NO_APPLICATION_TERMINATION_SUPPORT
    GUARD_OPERATION
    if (findThreads(t) == 0)
    {
    	addThreads(t);
    }
    #endif // !OM_NO_APPLICATION_TERMINATION_SUPPORT
    //#]
}

OMThread* OMThreadManager::stopAllThreads(const OMThread* skipme) const {
    //#[ operation stopAllThreads(OMThread) const 
    #ifdef _OMINSTRUMENT
    AnimServices::notifyEndApplication(false);
    #endif // _OMINSTRUMENT
    
    OMThread::endOfProcess = true;
    OMThread* currentThread = 0;
    OMThread* mainT = OMMainThread::instance(0);
    //First we need to stop all the registered OMThreads 
    //and then stop the OMMainThread
    OMList<OMThread*> threadListCopy(threads);
    OMIterator<OMThread*> threadIter(threadListCopy);
    OMList<void*> osthreadList ;
    void* currentThreadOsHandle = OMOSFactory::instance()->getCurrentThreadHandle();
    // build OS handle list
    while (*threadIter)
    {
    	OMThread* t = *threadIter;
    	if ((t->allowDeleteInThreadsCleanup()) &&
    		(t !=  mainT) &&
    		(t != skipme))
    	{
    		// add the os thread to the list
    		void* osHandle = 0;
    		(void) t->getOsHandle(osHandle);
    		osthreadList.add(osHandle);
    	
    		if ( t->getOsHandle() != currentThreadOsHandle)
    		{
    			// send termination event to stop the thread gracefully
    			t->endDispatching();
    		}
    		else
    		{
    			// this is the context thread
    			currentThread = t;
    		}
    	}
    	++threadIter;
    }
    OMIterator<void*> osThreadIter(osthreadList);
    while (*osThreadIter)
    {
    	// wait for the os threads to terminate
    	(void) OMOSFactory::instance()->waitOnThread(*osThreadIter, 1000);
    	++osThreadIter;
    }
    // Stop the main thread
    if ((mainT != 0) &&
    	(mainT != currentThread) &&
    	(mainT != skipme))
    {
    	void* osHandle = 0;
    	(void) mainT->getOsHandle(osHandle) ;
    	mainT->endDispatching();
    	(void) OMOSFactory::instance()->waitOnThread(osHandle, 1000) ;
    }
    return currentThread;
    //#]
}

void OMThreadManager::wakeup(IOxfActive* thread) const {
    //#[ operation wakeup(IOxfActive) const 
    // create & initialize a static wakeup token
    static OMEvent animWakeupEv(OMAnimWakeupEventId, 0);
    static bool initialized = false;
    if (!initialized)
    {
    	initialized = true;
    	animWakeupEv.setFrameworkEvent(true);
    	animWakeupEv.setDeleteAfterConsume(false);
    }
    if (thread != 0)
    {
    	OMOSEventGenerationParams params(false);
    	(void) thread->queue(&animWakeupEv,params);
    }
    //#]
}

OMIterator<OMThread*> OMThreadManager::getThreads() const {
    OMIterator<OMThread*> iter(threads);
    return iter;
}

void OMThreadManager::addThreads(OMThread* p_OMThread) {
    threads.add(p_OMThread);
}

void OMThreadManager::removeThreads(OMThread* p_OMThread) {
    threads.remove(p_OMThread);
}

void OMThreadManager::clearThreads() {
    threads.removeAll();
}

int OMThreadManager::findThreads(OMThread* p_OMThread) const {
    return threads.find(p_OMThread);
}

void OMThreadManager::cleanUpRelations() {
    {
        threads.removeAll();
    }
}



//
//! Log: $Log: OMThreadManager.cpp $
//! Log: Revision 1.21  2007/04/06 07:07:50  ilgiga
//! Log: bug fix 98191
//


