//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMMemoryManagerSwitchHelper
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMMemoryManagerSwitchHelper.h $
//!	File version	: $Revision: 1.17 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:45 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMMemoryManagerSwitchHelper_H 

#define OMMemoryManagerSwitchHelper_H 

#include "rawtypes.h"

//----------------------------------------------------------------------------
// OMMemoryManagerSwitchHelper.h                                                                  
//----------------------------------------------------------------------------

class OMMemoryManagerSwitchHelperImpl;

//## package Design::oxf::Services::MemoryManagement::Manager 


// Support switch of the memory manager after memory was already requested.
// This support is required since the memory must return via the manager that allocated it.
// This class supply the interface, the actual implementation is provided by the OMMemoryManagerSwitchHelperImpl that 
// should not be accessed directly.
//## class OMMemoryManagerSwitchHelper 

//#[ ignore 
#if (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))


#ifdef OM_ENABLE_MEMORY_MANAGER_SWITCH
// use the argument name
#define ommmswArg(arg) arg
#else
// remove the argument name
#define ommmswArg(arg)
#endif //OM_ENABLE_MEMORY_MANAGER_SWITCH

//#]
class RP_FRAMEWORK_DLL OMMemoryManagerSwitchHelper  {


////    Operations    ////
public :
    
    // cleanup the allocated memory list
    //## operation cleanup() const 
    void cleanup() const;
    
    // search for a recorded memory allocation
    // return 'true' if the memory was found in the recorded memory
    //  or 'false' when the memory is not found
    // Argument const void * ommmswArg(memory) : 
    // The memory to find
    //## operation findMemory(void *) const 
    bool findMemory(const void * ommmswArg(memory)) const;
    
    // return the internally used singleton instance 
    // of the OMMemoryManagerSwitchHelper
    //## operation instance() 
    static OMMemoryManagerSwitchHelper* instance();
    
    // check if the memory log is empty
    //## operation isLogEmpty() const 
    bool isLogEmpty() const;
    
    // record a single memory allocation
    // return true on success
    // Argument const void * ommmswArg(memory) : 
    // The memory to record
    //## operation recordMemoryAllocation(void *) const 
    bool recordMemoryAllocation(const void * ommmswArg(memory)) const;
    
    // record a single memory deallocation
    // return true if memory record found & removed ok
    // Argument const void * ommmswArg(memory) : 
    // The memory to deallocate
    //## operation recordMemoryDeallocation(void *) const 
    bool recordMemoryDeallocation(const void * ommmswArg(memory)) const;
    
    // Set the switch helper updating state
    // Argument bool ommmswArg(val) : 
    // When true enable the switch helper otherwise disable it
    //## operation setUpdateState(bool) const 
    void setUpdateState(bool ommmswArg(val)) const;
    
    // Check if the switch helper should be updated
    //## operation shouldUpdate() const 
    bool shouldUpdate() const;


};

//#[ ignore 

#endif //(!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]



#endif  
//
//! Log: $Log: OMMemoryManagerSwitchHelper.h $
//! Log: Revision 1.17  2007/04/06 07:07:45  ilgiga
//! Log: bug fix 98191
//


