//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMMainThread
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMMainThread.cpp $
//!	File version	: $Revision: 1.23 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:43 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: OMMainThread.cpp 1.23 2007/04/06 07:07:43 ilgiga Exp $";
#endif
//#]

#include "OMMainThread.h"

//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
#include <aom/AnimServices.h>

//#[ ignore 
#endif //_OMINSTRUMENT
//#]
#include "OXFGuardMacros.h"
#include "IOxfTimeout.h"
#include "OMEvent.h"
#include "OMEventQueue.h"
#include "OMIterator.h"
#include "os.h"
#include "OMOSEventGenerationParams.h"
#include "omreactive.h"
#include "OMThreadManager.h"
#include "OMTimeout.h"
#include "OMTimerManager.h"
#include "oxf.h"

//----------------------------------------------------------------------------
// OMMainThread.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Initialization 

//## class OMMainThread 


OMMainThread::OMMainThread() : OMThread(true) /* create a wrapper thread */ {
    //#[ operation OMMainThread() 
    #ifdef _OMINSTRUMENT
    AnimServices::setThreadName(getOsHandle(), "mainThread");
    #endif
    //#]
}


//#[ ignore 
/*
//#]
OMMainThread::OMMainThread(const OMMainThread& other) {
    //#[ operation OMMainThread(OMMainThread) 
    //#]
}

//#[ ignore 

*/
//#]

OMMainThread::~OMMainThread() {
    //#[ operation ~OMMainThread() 
    /* assuming the thread will not be re-created, nothing to do */
    //#]
}

OMMainThread* OMMainThread::getInstance() {
    //#[ operation getInstance() 
    static OMMainThread theMainThread;
    return &theMainThread;
    //#]
}

OMThread* OMMainThread::instance(bool create) {
    //#[ operation instance(bool) 
    IOxfActive* defaultActive = OXF::getTheDefaultActiveClass();
    if (!defaultActive && create) {
    	defaultActive = getInstance();
    	(void) OXF::setTheDefaultActiveClass(defaultActive);
    }
    return static_cast<OMThread*>(defaultActive);
    //#]
}

OMThread* OMMainThread::instance(int create) {
    //#[ operation instance(int) 
    return instance(create != 0);
    //#]
}


//#[ ignore 
/*
//#]
OMMainThread& OMMainThread::operator=(const OMMainThread& other) {
    //#[ operation operator=(OMMainThread) 
    return *this;
    //#]
}

//#[ ignore 

*/
//#]

void OMMainThread::startDispatching(bool doFork) {
    //#[ operation startDispatching(bool) 
    if (!doFork)
    {
    	// The main thread simply grabs the control from the system
    	(void)OMMainThread::execute();
    }
    else
    {
    	// the default active class is running on its own thread
    	OMOSThread* oldWrapperThread = getOsThread();
    	// Creating a thread of control
    	setOsThread(OMOSFactory::instance()->createOMOSThread(doExecute, this, "mainThread"));
    #ifdef _OMINSTRUMENT
    	AnimServices::switchOSThread(oldWrapperThread->getOsHandle(), getOsHandle());
    #endif
    	// delete the OSAL wrapper on the system main thread.
    	delete oldWrapperThread;
    	// start the event loop on the new thread
    	if (getOsThread())
    	{
    		getOsThread()->start();
    	}
    }
    //#]
}



//
//! Log: $Log: OMMainThread.cpp $
//! Log: Revision 1.23  2007/04/06 07:07:43  ilgiga
//! Log: bug fix 98191
//


