//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMHandleCloser
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMHandleCloser.cpp $
//!	File version	: $Revision: 1.27 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:42 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: OMHandleCloser.cpp 1.27 2007/04/06 07:07:42 ilgiga Exp $";
#endif
//#]

#include "OMHandleCloser.h"

//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
#include <aom/AnimServices.h>

//#[ ignore 
#endif //_OMINSTRUMENT
//#]
#include "OXFEvents.h"
#include "IOxfActive.h"
#include "IOxfEvent.h"
#include "OXFNotifyMacros.h"
#include "OMAnimReactive.h"
#include "state.h"
#include "OMEvent.h"
#include "OMMainThread.h"
#include "os.h"
#include "omprotected.h"
#include "OMTimeout.h"
#include "OMTimerManager.h"
#include "oxf.h"

//----------------------------------------------------------------------------
// OMHandleCloser.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::ResourceManagement 

//## class OMHandleCloser 


// Static class member attribute
bool OMHandleCloser::_singletonDestroyed = false;

OMHandleCloser::OMHandleCloser(OMHandleCloser::closeHandleFunc doCloseHandlePtr) : doCloseHandle(doCloseHandlePtr) ,
thread("_omCloseHandle", OMOSThread::DefaultThreadPriority, OMOSThread::DefaultStackSize, 
OMOSThread::DefaultMessageQueueSize, true) {
    initStatechart();
    //#[ operation OMHandleCloser(closeHandleFunc) 
    OMReactive::setActiveContext(&thread, true);
    thread.setDeletionAllowed(false);
    setFrameworkInstance(true);
    #ifdef _OMINSTRUMENT
    AnimServices::setThreadName(thread.getOsHandle(), "_omCloseHandle");
    #endif
    //#]
}


//#[ ignore 
/*
//#]
OMHandleCloser::OMHandleCloser(const OMHandleCloser& other) : OMReactive(), doCloseHandle(0) ,thread("_omCloseHandle", 
OMOSThread::DefaultThreadPriority, OMOSThread::DefaultStackSize, OMOSThread::DefaultMessageQueueSize, true) {
    initStatechart();
    //#[ operation OMHandleCloser(OMHandleCloser) 
    //#]
}

//#[ ignore 

*/
//#]

OMHandleCloser::~OMHandleCloser() {
    //#[ operation ~OMHandleCloser() 
    // this class dies only at the end of the process since it is a singleton
    #ifdef _OMINSTRUMENT
    AnimServices::notifyEndApplication(false);
    #endif // _OMINSTRUMENT
    
    OMThread::endOfProcess = true;
    _singletonDestroyed = true;
    //#]
}

void OMHandleCloser::genCloseEvent(void * hObject) {
    //#[ operation genCloseEvent(void *) 
    if (!_singletonDestroyed) {
    	OMEvent * closeHandle = new OMCloseHandleEvent(hObject);
    	closeHandle->setFrameworkEvent(true);
    	(void) send(closeHandle);
    }
    //#]
}

OMHandleCloser &  OMHandleCloser::getInstance(OMHandleCloser::closeHandleFunc doCloseHandlePtr) {
    //#[ operation getInstance(closeHandleFunc) 
    static OMHandleCloser theHandleCloser(doCloseHandlePtr);
    return theHandleCloser;
    //#]
}

OMThread* OMHandleCloser::getThread() const {
    //#[ operation getThread() const 
    return const_cast<OMThread*>(&thread);
    //#]
}

OMHandleCloser* OMHandleCloser::instance() {
    //#[ operation instance() 
    OMHandleCloser* theHandleCloser = &getInstance(NULL); 
    if (theHandleCloser->doCloseHandle == NULL) {
    	theHandleCloser = NULL;
    }
    return theHandleCloser;
    //#]
}

OMHandleCloser* OMHandleCloser::instance(OMHandleCloser::closeHandleFunc doCloseHandlePtr) {
    //#[ operation instance(closeHandleFunc) 
    return &getInstance(doCloseHandlePtr);
    //#]
}


//#[ ignore 
/*
//#]
OMHandleCloser& OMHandleCloser::operator=(const OMHandleCloser& other) {
    //#[ operation operator=(OMHandleCloser) 
    return *this;
    //#]
}

//#[ ignore 

*/
//#]

void OMHandleCloser::sendCloseHandleCloserEvent() {
    //#[ operation sendCloseHandleCloserEvent() 
    if (!_singletonDestroyed)
    {
    	thread.endDispatching();
    }
    //#]
}

bool OMHandleCloser::startBehavior() {
    //#[ operation startBehavior() 
    bool done = false;
    done = OMReactive::startBehavior();
    if (done) {
        thread.startDispatching();
    }
    return done;
    //#]
}

void OMHandleCloser::rootState_entDef() {
    {
        rootState_subState = ready;
        rootState_active = ready;
    }
}

IOxfReactive::TakeEventStatus OMHandleCloser::rootState_processEvent() {
    IOxfReactive::TakeEventStatus res = eventNotConsumed;
    switch (rootState_active) {
        case ready:
        {
            if(IS_EVENT_TYPE_OF(OMCloseHandleEvent_Events_Services_oxf_Design_id))
                {
                    OMSETPARAMS(OMCloseHandleEvent);
                    //## transition 1 
                    if(doCloseHandle)
                        {
                            //#[ transition 1 
                            
                            (*doCloseHandle)(params->handle);
                            //#]
                            rootState_subState = ready;
                            rootState_active = ready;
                            res = eventConsumed;
                        }
                }
            
            break;
        }
        default:
            break;
    }
    return res;
}

void OMHandleCloser::initStatechart() {
    rootState_subState = OMNonState;
    rootState_active = OMNonState;
}



//
//! Log: $Log: OMHandleCloser.cpp $
//! Log: Revision 1.27  2007/04/06 07:07:42  ilgiga
//! Log: bug fix 98191
//


