//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMEventQueue
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMEventQueue.h $
//!	File version	: $Revision: 1.14 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:42 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMEventQueue_H 

#define OMEventQueue_H 

#include "IOxfEvent.h"
#include "OMOSEventGenerationParams.h"
#include "os.h"

//----------------------------------------------------------------------------
// OMEventQueue.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::RTOSWrappers 


// An instantiation class of the event queue wrapper over the RTOS message queue.
// The message type is IOxfEvent*.
//## class OMEventQueue 
class RP_FRAMEWORK_DLL OMEventQueue  {

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :
    
    // Initialize
    // Argument const long messageQueueSize : 
    // The RTOS message queue size
    // Argument bool dynamicMessageQueue : 
    // When true, the RTOS queue size should be dynamic (grow on demand)
    //## operation OMEventQueue(long,bool) 
    OMEventQueue(const long messageQueueSize, bool dynamicMessageQueue) : theQueue(0) {
        //#[ operation OMEventQueue(long,bool) 
        init(messageQueueSize, dynamicMessageQueue);
        //#]
    }
    
    
    // Initialize without creating of the RTOS queue
    //## operation OMEventQueue() 
    OMEventQueue() : theQueue(0) {
        //#[ operation OMEventQueue() 
        //#]
    }
    
    
    // Cleanup
    //## operation ~OMEventQueue() 
    virtual ~OMEventQueue() {
        //#[ operation ~OMEventQueue() 
        cleanup();
        //#]
    }
    


////    Operations    ////
public :
    
    // cleanup the RTOS resources
    //## operation cleanup() 
    inline void cleanup() {
        //#[ operation cleanup() 
        if (theQueue != 0)
        {
        	delete theQueue;
        	theQueue = 0;
        }
        //#]
    }
    
    
    // Get an event from the queue
    //## operation get() 
    inline virtual IOxfEvent* get() {
        //#[ operation get() 
        IOxfEvent* msg = 0;
        if (theQueue)
        {
        	msg = reinterpret_cast<IOxfEvent*>(theQueue->get());
        }
        return msg;
        //#]
    }
    
    
    // Get a list of the events in the queue
    // Argument OMList<IOxfEvent*> & l : 
    // The output list
    //## operation getMessageList(OMList<IOxfEvent*> & ) 
    inline virtual void getMessageList(OMList<IOxfEvent*> & l) {
        //#[ operation getMessageList(OMList<IOxfEvent*> & ) 
        if (theQueue)
        {
        	theQueue->getMessageList(reinterpret_cast< OMList<void*>& >(l));
        }
        //#]
    }
    
    
    // Get the RTOS queue 
    //## operation getOsHandle() const 
    inline virtual void * getOsHandle() const {
        //#[ operation getOsHandle() const 
        void* h = 0;
        if (theQueue)
        {
        	h = theQueue->getOsHandle();
        }
        return h;
        //#]
    }
    
    
    // Initialize the RTOS queue
    // Argument const long messageQueueSize : 
    // The RTOS message queue size
    // Argument bool dynamicMessageQueue : 
    // When true, the RTOS queue size should be dynamic (grow on demand)
    //## operation init(long,bool) 
    inline void init(const long messageQueueSize = OMOSThread::DefaultMessageQueueSize, bool dynamicMessageQueue = true
    ) {
        //#[ operation init(long,bool) 
        if (theQueue == 0)
        {
        	theQueue = OMOSFactory::instance()->createOMOSMessageQueue(dynamicMessageQueue, messageQueueSize);
        }
        //#]
    }
    
    
    // Check if the queue is empty
    //## operation isEmpty() const 
    inline virtual bool isEmpty() const {
        //#[ operation isEmpty() const 
        bool empty = true;
        if (theQueue)
        {
        	empty = (theQueue->isEmpty() != 0);
        }
        return empty;
        //#]
    }
    
    
    // Check if the queue is full (dynamic queues are never full)
    //## operation isFull() const 
    inline virtual bool isFull() const {
        //#[ operation isFull() const 
        bool full = true;
        if (theQueue)
        {
        	full = theQueue->isFull();
        }
        return full;
        //#]
    }
    
    
    // Block on the queue until a message arrives (non-blocking if there are messages in the queue)
    //## operation pend() 
    inline virtual void pend() {
        //#[ operation pend() 
        if (theQueue)
        {
        	theQueue->pend();
        }
        //#]
    }
    
    
    // Put an event into the queue
    // Argument IOxfEvent* ev : 
    // The event
    //## operation put(IOxfEvent*) 
    inline virtual bool put(IOxfEvent* ev) {
        //#[ operation put(IOxfEvent*) 
        bool res = false;
        if (theQueue)
        {
        	OMOSEventGenerationParams params;
        	res = putMessage(ev, params);
        }
        return res;
        //#]
    }
    
    
    // Put a event into the queue
    // Argument IOxfEvent* ev : 
    // The event
    // Argument const IOxfEventGenerationParams& params : 
    // Put parameters
    //## operation putMessage(IOxfEvent*,IOxfEventGenerationParams) 
    inline virtual bool putMessage(IOxfEvent* ev, const IOxfEventGenerationParams& params) {
        //#[ operation putMessage(IOxfEvent*,IOxfEventGenerationParams) 
        bool res = false;
        if (theQueue)
        {
        	res = theQueue->putMessage(reinterpret_cast<void*>(ev), params);
        }
        return res;
        //#]
    }
    


////    Additional operations    ////
public :
    
    //## auto_generated 
    inline OMOSMessageQueue* getOsQueue() const {
        return theQueue;
    }
    


////    Relations and components    ////
private :
    
    // The RTOS message queue
    OMOSMessageQueue* theQueue;		//## link theQueue 
    


};


#endif  
//
//! Log: $Log: OMEventQueue.h $
//! Log: Revision 1.14  2007/04/06 07:07:42  ilgiga
//! Log: bug fix 98191
//


