//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMDelay
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMDelay.h $
//!	File version	: $Revision: 1.16 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:40 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMDelay_H 

#define OMDelay_H 

#include "rawtypes.h"

//----------------------------------------------------------------------------
// OMDelay.h                                                                  
//----------------------------------------------------------------------------

class AnimServices;
class OMOSEventFlag;
class OMTimeout;
class OMTimerManager;

//## package Design::oxf::Services::Time::TimeManagement 


// Delay the calling thread
//## class OMDelay 
class RP_FRAMEWORK_DLL OMDelay  {


////    Constructors and destructors    ////
public :
    
    // Initialize a delay class
    // Argument OxfTimeUnit t : 
    // The delay time
    //## operation OMDelay(OxfTimeUnit) 
    OMDelay(OxfTimeUnit t);
    
    // Cleanup
    //## operation ~OMDelay() 
    ~OMDelay();

private :
    
    // the copy ctor and the assignment operator should not be used
    // Argument const OMDelay& delay : 
    // The delay to copy
    //## operation OMDelay(OMDelay) 
    OMDelay(const OMDelay& delay);    //lint !e1704 !e1526 (disable copy constructor)


////    Operations    ////
public :
    
    // Wakeup  the delayed thread
    //## operation wakeup() 
    void wakeup();

private :
    
    // Disabled assignment operator
    // Argument const OMDelay& delay : 
    // The delay to copy
    //## operation operator=(OMDelay) 
    OMDelay& operator=(const OMDelay& delay);   //lint !e1526 (disable copy constructor)


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void cleanUpRelations();


////    Relations and components    ////
private :
    
    OMOSEventFlag* stopSignal;		//## link stopSignal 
    


};


#endif  
//
//! Log: $Log: OMDelay.h $
//! Log: Revision 1.16  2007/04/06 07:07:40  ilgiga
//! Log: bug fix 98191
//


