//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMDelay
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMDelay.cpp $
//!	File version	: $Revision: 1.19 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:40 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: OMDelay.cpp 1.19 2007/04/06 07:07:40 ilgiga Exp $";
#endif
//#]

#include "OMDelay.h"

//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
#include <aom/AnimServices.h>

//#[ ignore 
#endif //_OMINSTRUMENT
//#]
#include "os.h"
#include "OMTimeout.h"
#include "OMTimerManager.h"

//----------------------------------------------------------------------------
// OMDelay.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Time::TimeManagement 

//## class OMDelay 




//#[ ignore 
/*
//#]
OMDelay::OMDelay(const OMDelay& delay) {
    //#[ operation OMDelay(OMDelay) 
    //#]
}

//#[ ignore 

*/
//#]

OMDelay::OMDelay(OxfTimeUnit t) {
    //#[ operation OMDelay(OxfTimeUnit) 
    // Create the stop signal 
    stopSignal = OMOSFactory::instance()->createOMOSEventFlag();
    if (stopSignal) {
    	stopSignal->reset();
    }
    // Create the timeout event
    OMTimeout* timeout = new OMTimeout(reinterpret_cast<IOxfReactive*>(this), t, NULL);
    timeout->setDelayTimeout();
    // Delegating the request to timer
    OMTimerManager* sysTimer = OMTimerManager::instance();
    if (sysTimer)
    {	
    	(void) sysTimer->set(timeout); 
    	// while waiting - we should consider the thread as idle.
    	sysTimer->decNonIdleThreadCounter();
    }
    // stop and wait for this timeout
    
    #ifdef _OMINSTRUMENT
    // notify my stepper that I'm stopping
    AnimServices::notifyMutexLock(false);
    #endif
    
    // Actually stop
    if (stopSignal)
    {
    	stopSignal->wait();
    }
    
    #ifdef _OMINSTRUMENT
    // notify my stepper that I'm continuing
    AnimServices::notifyMutexLock(true);
    #endif
    //#]
}

OMDelay::~OMDelay() {
    //#[ operation ~OMDelay() 
    delete stopSignal;
    stopSignal = NULL;
    //#]
    cleanUpRelations();
}


//#[ ignore 
/*
//#]
OMDelay& OMDelay::operator=(const OMDelay& delay) {
    //#[ operation operator=(OMDelay) 
    //#]
}

//#[ ignore 

*/
//#]

void OMDelay::wakeup() {
    //#[ operation wakeup() 
    if (stopSignal)
    {
    	stopSignal->signal();
    }
    //#]
}

void OMDelay::cleanUpRelations() {
    if(stopSignal != 0)
        {
            stopSignal = 0;
        }
}



//
//! Log: $Log: OMDelay.cpp $
//! Log: Revision 1.19  2007/04/06 07:07:40  ilgiga
//! Log: bug fix 98191
//


