//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMDefaultOutBound
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMDefaultOutBound.h $
//!	File version	: $Revision: 1.17 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:38 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMDefaultOutBound_H 

#define OMDefaultOutBound_H 

#include "IOxfReactive.h"

//----------------------------------------------------------------------------
// OMDefaultOutBound.h                                                                  
//----------------------------------------------------------------------------

class IOxfActive;
class IOxfEvent;
class OMOSEventGenerationParams;

//## package Design::oxf::Services::Ports 


// default out-bound port to a reactive instance.
// forward the events to the reactive target.
//## class OMDefaultOutBound 
class RP_FRAMEWORK_DLL OMDefaultOutBound : public IOxfReactive {


////    Constructors and destructors    ////
public :
    
    // Initialize
    //## operation OMDefaultOutBound() 
    OMDefaultOutBound();
    
    //## auto_generated 
    virtual ~OMDefaultOutBound();


////    Operations    ////
public :
    
    // cleanup references to the specified timeout
    // return true if the reference was removed.
    // Argument const IOxfTimeout* /*timeout*/ : 
    // the timeout to remove references to
    //## operation cancelTimeout(IOxfTimeout) 
    bool cancelTimeout(const IOxfTimeout* /*timeout*/);
    
    // destroy the reactive instance (delete should never be called directly)
    //## operation destroy() 
    void destroy();
    
    // signal that the reactive instance reached a terminate connector
    // Argument const char* /*theTerminator*/ : 
    // the termination connector name
    //## operation endBehavior(char*) 
    virtual void endBehavior(const char* /*theTerminator*/ = 0);
    
    // Unused, needed to realize the entire IOxfReactive interface
    //## operation getActiveContext() const 
    IOxfActive* getActiveContext() const;
    
    // Unused, needed to realize the entire IOxfReactive interface
    //## operation getCurrentEvent() const 
    IOxfEvent* getCurrentEvent() const;
    
    // consume an event
    // Argument IOxfEvent* /*ev*/ : 
    // The event
    //## operation handleEvent(IOxfEvent) 
    IOxfReactive::TakeEventStatus handleEvent(IOxfEvent* /*ev*/);
    
    // signal that a null transition was taken (called by the generated code)
    //## operation popNullTransition() 
    void popNullTransition();
    
    // signal that there is a null transition to be taken (called by the generated code)
    //## operation pushNullTransition() 
    void pushNullTransition();
    
    // send an event to the active context queue
    // Argument IOxfEvent* ev : 
    // The event
    // Argument const IOxfEventGenerationParams& params : 
    // Sending parameters
    //## operation send(IOxfEvent,IOxfEventGenerationParams) 
    bool send(IOxfEvent* ev, const IOxfEventGenerationParams& params);
    
    // send the specified event to the instance active context queue
    // Argument IOxfEvent* ev : 
    // The event
    //## operation send(IOxfEvent) 
    bool send(IOxfEvent* ev);
    
    // Unused, needed to realize the entire IOxfReactive interface
    // Argument IOxfActive* /**/ : 
    // The active context
    //## operation setActiveContext(IOxfActive) 
    void setActiveContext(IOxfActive* /**/);
    
    // initialize the reactive instance state machine
    //## operation startBehavior() 
    bool startBehavior();

protected :
    
    // react to an event that was not consumed.
    // note that the event can be allocated on the stack.
    // Argument IOxfEvent* /*ev*/ : 
    // The event
    // Argument IOxfReactive::EventNotConsumedReason /*reason*/ : 
    // The reason
    //## operation handleNotConsumed(IOxfEvent,EventNotConsumedReason) 
    void handleNotConsumed(IOxfEvent* /*ev*/, IOxfReactive::EventNotConsumedReason /*reason*/);
    
    // consume a triggered operation (synchronous event)
    // Argument IOxfEvent* /*ev*/ : 
    // The call-event
    //## operation handleTrigger(IOxfEvent) 
    void handleTrigger(IOxfEvent* /*ev*/);
    
    // schedule a timeout to be consumed by the reactive instance.
    // Argument OxfTimeUnit /*delay*/ : 
    // The delay
    // Argument const char* /*targetStateName*/ : 
    // The state name
    //## operation scheduleTimeout(OxfTimeUnit,char) 
    IOxfTimeout* scheduleTimeout(OxfTimeUnit /*delay*/, const char* /*targetStateName*/ = 0);


////    Additional operations    ////
public :
    
    //## auto_generated 
    IOxfReactive* getItsDefaultRequiredInterface() const;
    
    //## auto_generated 
    void setItsDefaultRequiredInterface(IOxfReactive* p_IOxfReactive);


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void cleanUpRelations();


////    Relations and components    ////
private :
    
    // The port required interface
    IOxfReactive* itsDefaultRequiredInterface;		//## link itsDefaultRequiredInterface 
    


};


#endif  
//
//! Log: $Log: OMDefaultOutBound.h $
//! Log: Revision 1.17  2007/04/06 07:07:38  ilgiga
//! Log: bug fix 98191
//


