//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMAnimReactive
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMAnimReactive.h $
//!	File version	: $Revision: 1.17 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:36 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMAnimReactive_H 

#define OMAnimReactive_H 

#include "IOxfAnimReactive.h"
#include "OXFManager.h"

//----------------------------------------------------------------------------
// OMAnimReactive.h                                                                  
//----------------------------------------------------------------------------

class IOxfReactive;
class OMEventQueue;
class OMReactive;
class OMThread;

//## package Design::oxf::Anim::AnimImplementation 


// OMReactive animation wrapper
//## class OMAnimReactive 
class RP_FRAMEWORK_DLL OMAnimReactive : public IOxfAnimReactive {

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :
    
    // initialization
    // Argument OMReactive* context : 
    // The reactive instance to wrap
    //## operation OMAnimReactive(OMReactive) 
    OMAnimReactive(OMReactive* context);
    
    //## auto_generated 
    ~OMAnimReactive();


////    Operations    ////
public :
    
    // Checks if the queue can accept a new event (if it is not full)
    //## operation canAcceptEvents() const 
    bool canAcceptEvents() const;
    
    // get the identifier of the OS thread that is associated with the active context of the reactive instance
    //## operation getContextThread() const 
    void * getContextThread() const;
    
    // Returns the "real" reactive part. 
    // Used (for example) to send events
    //## operation getOxfReactive() const 
    IOxfReactive* getOxfReactive() const;
    
    // Send an animated event to the reactive context
    // Argument IOxfEvent* ev : 
    // The event
    // Argument void * sender : 
    // The event sender
    //## operation send(IOxfEvent,void *) 
    bool send(IOxfEvent* ev, void * sender);
    
    // Serializes the states.
    // Argument AOMSState* aomArg(states) : 
    // The animation states vector to fill.
    // AnimServices provides operations to fill the vector so all you need to do is to pass this pointer to these 
    // operations.
    //## operation serializeStates(AOMSState) const 
    void serializeStates(AOMSState* aomArg(states)) const;

private :
    
    // Get the thread
    //## operation getThread() const 
    OMThread* getThread() const;


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void cleanUpRelations();


////    Relations and components    ////
private :
    
    // The reactive instance
    OMReactive* oxfReactive;		//## link oxfReactive 
    


};


#endif  
//
//! Log: $Log: OMAnimReactive.h $
//! Log: Revision 1.17  2007/04/06 07:07:36  ilgiga
//! Log: bug fix 98191
//


