//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMAnimReactive
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMAnimReactive.cpp $
//!	File version	: $Revision: 1.19 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:36 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: OMAnimReactive.cpp 1.19 2007/04/06 07:07:36 ilgiga Exp $";
#endif
//#]

#include "OMAnimReactive.h"
#include "IOxfReactive.h"
#include "OMEventQueue.h"
#include "omreactive.h"
#include "omthread.h"

//----------------------------------------------------------------------------
// OMAnimReactive.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Anim::AnimImplementation 

//## class OMAnimReactive 



OMAnimReactive::OMAnimReactive(OMReactive* context) : oxfReactive(context) {
    //#[ operation OMAnimReactive(OMReactive) 
    //#]
}

OMAnimReactive::~OMAnimReactive() {
    cleanUpRelations();
}

bool OMAnimReactive::canAcceptEvents() const {
    //#[ operation canAcceptEvents() const 
    bool res = false;
    OMThread* t = getThread();
    if (t != 0)
    {
    	const OMEventQueue* q = t->getEventQueue();
    	if (q != 0)
    	{
    		res = (!q->isFull());
    	}
    }
    return res;
    //#]
}

void * OMAnimReactive::getContextThread() const {
    //#[ operation getContextThread() const 
    void* osThread = 0;
    OMThread* t = getThread();
    if (t != 0)
    {
    	osThread = t->getOsHandle();
    }
    return osThread;
    //#]
}

IOxfReactive* OMAnimReactive::getOxfReactive() const {
    //#[ operation getOxfReactive() const 
    return oxfReactive;
    //#]
}

OMThread* OMAnimReactive::getThread() const {
    //#[ operation getThread() const 
    OMThread* t = 0;
    if (oxfReactive != 0)
    {
    	// IMPORTANT: at this level we assume coupling between OMReactive and OMThread
    	t = static_cast<OMThread*>(oxfReactive->getActiveContext());
    }
    return t;
    //#]
}

bool OMAnimReactive::send(IOxfEvent* ev, void * sender) {
    //#[ operation send(IOxfEvent,void *) 
    bool res = false;
    if (oxfReactive != 0)
    {
    	OMOSEventGenerationParams params(sender);
    	res = oxfReactive->send(ev, params);
    }
    return res;
    //#]
}

void OMAnimReactive::serializeStates(AOMSState* aomArg(states)) const {
    //#[ operation serializeStates(AOMSState) const 
    #ifdef _OMINSTRUMENT
    if (oxfReactive != 0)
    {
    	oxfReactive->serializeStates(states);
    }
    #endif
    //#]
}

void OMAnimReactive::cleanUpRelations() {
    if(oxfReactive != 0)
        {
            oxfReactive = 0;
        }
}



//
//! Log: $Log: OMAnimReactive.cpp $
//! Log: Revision 1.19  2007/04/06 07:07:36  ilgiga
//! Log: bug fix 98191
//


