//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: IOxfMemoryAllocator
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/IOxfMemoryAllocator.h $
//!	File version	: $Revision: 1.10 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:31 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef IOxfMemoryAllocator_H 

#define IOxfMemoryAllocator_H 

#include "rawtypes.h"

//----------------------------------------------------------------------------
// IOxfMemoryAllocator.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::MemoryManagement::MemoryAPI 


// Memory manager interface
//## class IOxfMemoryAllocator 
class RP_FRAMEWORK_DLL IOxfMemoryAllocator  {


////    Constructors and destructors    ////
public :
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~IOxfMemoryAllocator() 
    virtual ~IOxfMemoryAllocator() {
        //#[ operation ~IOxfMemoryAllocator() 
        //#]
    }
    


////    Operations    ////
public :
    
    // get a memory block of the specified size
    // Argument size_t size : 
    // The memory size in bytes
    //## operation getMemory(size_t) 
    virtual void * getMemory(size_t size)=0;
    
    // Return the memory of the object.
    // The size argument is available for optimization of the memory manager implementation (for example when several 
    // pools are used based on the requested memory size).
    // Argument void * object : 
    // The object to delete
    // Argument size_t size : 
    // The object size (in bytes)
    //## operation returnMemory(void *,size_t) 
    virtual void returnMemory(void * object, size_t size)=0;


};
//## package Design::oxf::Services::MemoryManagement::MemoryAPI::Compatibility 


// Rhapsody 5.X compatibility types

// Rhapsody 5.X name of the IOxfMemoryAllocator interface
//## type OMAbstractMemoryAllocator 
typedef IOxfMemoryAllocator OMAbstractMemoryAllocator;




#endif  
//
//! Log: $Log: IOxfMemoryAllocator.h $
//! Log: Revision 1.10  2007/04/06 07:07:31  ilgiga
//! Log: bug fix 98191
//


