//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: IOxfEvent
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/IOxfEvent.h $
//!	File version	: $Revision: 1.10 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:30 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef IOxfEvent_H 

#define IOxfEvent_H 

#include "OXFTypes.h"

//----------------------------------------------------------------------------
// IOxfEvent.h                                                                  
//----------------------------------------------------------------------------

class IOxfReactive;

//## package Design::oxf::Core::CoreAPI 


// An event (signal/message) interface.
// Events are used for synchronous and asynchronous messaging.
//## class IOxfEvent 
class RP_FRAMEWORK_DLL IOxfEvent  {
public :
    // An event id attribute type
    //## type ID 
    typedef short ID;
    
    


////    Constructors and destructors    ////
public :
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~IOxfEvent() 
    virtual ~IOxfEvent() {
        //#[ operation ~IOxfEvent() 
        //#]
    }
    


////    Operations    ////
public :
    
    // destroy the event
    //## operation destroy() 
    virtual void destroy()=0;
    
    // check if the event is a sub-type of an event with the specified id
    // Argument ID eventId : 
    // The event id to test
    //## operation isTypeOf(ID) const 
    virtual bool isTypeOf(ID eventId) const=0;


////    Additional operations    ////
public :
    
    //## auto_generated 
    virtual ID getId() const=0;
    
    //## auto_generated 
    virtual void setId(ID p_id)=0;
    
    //## auto_generated 
    virtual void * getPort() const=0;
    
    //## auto_generated 
    virtual void setPort(void * p_port)=0;
    
    //## auto_generated 
    virtual bool getSynchronous() const=0;
    
    //## auto_generated 
    virtual void setSynchronous(bool p_synchronous)=0;
    
    //## auto_generated 
    virtual IOxfReactive* getDestination() const=0;
    
    //## auto_generated 
    virtual void setDestination(IOxfReactive* p_IOxfReactive)=0;


};


#endif  
//
//! Log: $Log: IOxfEvent.h $
//! Log: Revision 1.10  2007/04/06 07:07:30  ilgiga
//! Log: bug fix 98191
//


