//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: IOxfAnimTimerManager
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/IOxfAnimTimerManager.h $
//!	File version	: $Revision: 1.13 $
//
//!	Date changed	: $Date: 2007/06/17 07:41:01 $
//!	Last change by	: $Author: ilelpa $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef IOxfAnimTimerManager_H 

#define IOxfAnimTimerManager_H 

#include "IOxfReactive.h"
#include "OXFTypes.h"

//----------------------------------------------------------------------------
// IOxfAnimTimerManager.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Anim::AnimAPI 


// An animation interface to the timer manager singleton class implementation
// Enables the animation layer to communicate with the timer manager implementation
//## class IOxfAnimTimerManager 
class RP_FRAMEWORK_DLL IOxfAnimTimerManager  {


////    Constructors and destructors    ////
public :
    
    // Cleanup
    //## operation ~IOxfAnimTimerManager() 
    virtual ~IOxfAnimTimerManager() {
        //#[ operation ~IOxfAnimTimerManager() 
        //#]
    }
    


////    Operations    ////
public :
    
    // advance the system time to the next waiting timeout
    //## operation advanceTime() 
    virtual void advanceTime()=0;
    
    // Returns the elapsed time
    //## operation getElapsedTime() const 
    virtual OxfTimeUnit getElapsedTime() const=0;
    
    // A service to be notified after deltaT time.
    // Argument IOxfReactive* reactive : 
    // The reactive requesting the service
    // Argument const OxfTimeUnit deltaT : 
    // The requested time to elapse
    // Argument OxfTimeUnit& baseTime : 
    // An output parameter containing the current time
    //## operation requestTimeNotification(IOxfReactive*,const OxfTimeUnit,IOxfTimeout*&,OxfTimeUnit&) 
    virtual void requestTimeNotification(IOxfReactive* reactive, const OxfTimeUnit deltaT, IOxfTimeout*& timeout, 
    OxfTimeUnit& baseTime)=0;
    
    // Resumes the timer manager after it was suspended
    //## operation resume() 
    virtual void resume()=0;
    
    // Suspends the timer manager
    //## operation suspend() 
    virtual void suspend()=0;


};


#endif  
//
//! Log: $Log: IOxfAnimTimerManager.h $
//! Log: Revision 1.13  2007/06/17 07:41:01  ilelpa
//! Log: Decoupling AOM-OXF
//


