#ifndef tomvisitor_H
#define tomvisitor_H "$Id: tomvisitor.h 1.3 2007/03/11 13:14:48 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tomvisitor.h $
//	file version:	$Revision: 1.3 $
//
//	purpose:	TOM List and derived class (proxy relations, proxy classes)
//
//	author(s):	  Yachin Pnueli
//	date started:	25.7.96
//	date changed:	$Date: 2007/03/11 13:14:48 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1998, 2007
//

#include "toxf.h"

class TOMAbstractVisitor {
public:
	virtual ~TOMAbstractVisitor() {};
};

template<class Result, class Argument>
class TOMVisitor1Arg : public TOMAbstractVisitor {
public:
	virtual Result execute(Argument arg) = 0;
};

class TOMProxyItem;

class TOMProxyVisitor1Arg : public TOMVisitor1Arg<OMBoolean,TOMProxyItem &> {
public:
	virtual OMBoolean execute(TOMProxyItem & proxy) = 0;
};

template<class Result, class Argument1, class Argument2>
class TOMVisitor2Arg : public TOMAbstractVisitor {
public:
	virtual Result execute(Argument1 arg1, Argument2 arg2) = 0;
};

//
// $Log: tomvisitor.h $
// Revision 1.3  2007/03/11 13:14:48  ilgiga
// Change copyright comment
// Revision 1.2  2007/03/04 15:07:39  ilgiga
// Telelogic instead of i-Logix
// Revision 1.1  1998/11/30 12:36:35  beery
// Initial revision
//

#endif


