#ifndef tomstep_H
#define tomstep_H "$Id: tomstep.h 1.48 2007/05/29 12:01:55 ilelpa Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tomstep.h $
//	file version:	$Revision: 1.48 $
//
//	purpose:	Define the TOMStepper class
//				and the TOMUI/TOMGUI classes
//
//	author(s):	Yachin Pnueli
//	date started:	30.7.96
//	date changed:	$Date: 2007/05/29 12:01:55 $
//	last change by:	$Author: ilelpa $
//
//	(c) Copyright Telelogic 1996, 2007
//
//
//	TOMStepper	-	The proxy
//
#include <stdio.h> 
#include "tomproxy.h"
#include <oxf/omstack.h>

class RP_ANIM_DLL TOMStepper :public TOMProxyItem {
	virtual void _showYourself(TOMUniversalObserver* , int&);
public:
	virtual ~TOMStepper() { }
	TOMStepper(void* theReal, OMInterestMask theMask)
		:TOMProxyItem(theReal, "Stepper", omProxyStepper, theMask) { }

	void setInterestMask(OMInterestMask newMask) {
		// Ugly but ensures we go through the same "send" procedure
		myLastSentMask = OMAllInterest; // Ensures we change mask value below
		TOMProxyItem::setInterestMask(newMask);
	}

	static TOMStepper * getCurrentStepper();
	void handleMessage(OMNotify r, TOMSData* s, OMSPosition p);
	virtual void handleMessage(AnimMessage* msg) { TOMProxyItem::handleMessage(msg); }
};



//
//	TOMUI class
//
RP_ANIM_DLL void createUIGUI();

enum TOMUIState {	waitForStart, 
					controlWithUser,
					controlWithApplication,
					failedLastCommand };


class RP_ANIM_DLL TOMUI {
	friend RP_ANIM_DLL void createUIGUI();
protected:
	static TOMUI * _instance;

	OMBoolean _needRefresh;

	OMStack<omistream *> inputs;
	OMBoolean readingFromFile() const { return !inputs.isEmpty(); }

	void readLine(char * line, int size);
	OMBoolean goSomething(char *&);
	OMBoolean traceSomething(char *&);
	TOMUIState showSomething(char *&);
	TOMUIState doSomething(TOMProxyVisitor1Arg & todo, char *&);
	OMBoolean outputSomething(char *&);
	OMBoolean logcmdSomething(char *&);
	OMBoolean inputSomething(char *&);
	OMBoolean suspendSomething(char *&);
	OMBoolean resumeSomething(char *&);
	OMBoolean setSomething(char *&);
	OMBoolean maskSomething(char *&);
	OMBoolean breakSomething(char *&);
	OMBoolean timestampSomething(char *&);
	OMBoolean generateEvent(char*&);
	OMBoolean callOperation(char*&);
	OMBoolean dbgStopSomething(char*&);
	TOMUIState myState;
	TOMUIState getAndDoUserRequest();
	omistream* getActiveInStream();
	OMBoolean actualyReadLine(omistream* file, char * line, int size);
	void clearAllInputs();
	virtual void uiTakeStart();
	// refresh all observers
	virtual void refresh();

	static const char *tomSearchPathEnvVarName;

	// logging commands 
	OMBoolean recordCommandsOn(const char* filename);
	char* getLogCmdFilename() const;
	OMBoolean recordCommandsOff();
	OMBoolean shouldRecordCommand() const;
	OMBoolean recordCommand(const char* cmd) const;
	void recordCmdIfNeeded(char* c) const;

	FILE* logCmdFilePtr;
	char logCmdFileName[256];
	

public:
	TOMUI(); 
	virtual ~TOMUI();

	TOMUIState doUserRequest(char*);

	// should be called only by test conductor
	// to get a notification after a certain time
	void requestTimeNotification(OxfTimeUnit time);

	virtual void notifyControl() { 
		if (myState==waitForStart) {
			uiTakeStart();
		}
		myState=controlWithUser;
		passControlToUser();
	}

	OMBoolean setInput(const char * fileName = "OMTracer.cfg", 
				  OMBoolean withMessage = TRUE,
				  OMBoolean replace=FALSE,
				  const char* path = NULL);

	virtual void passControlToUser();
	static TOMUI * instance();
};


//#ifdef OMANIMATOR
class RP_ANIM_DLL TOMGUI : public TOMUI {
private:
	int m_HasControl;
protected:
	// refresh all observers
	virtual void refresh();
public:
	TOMGUI();  //{ m_HasControl = 1; }
	virtual ~TOMGUI();
	void setOutput(omostream* os);
	void getControl(); // { m_HasControl = 1; }
	void passControlToUser();
	void uiTakeStart();
	int hasControl(); // { return m_HasControl; }

	static TOMGUI * instance()	{ return (TOMGUI *)_instance; }

	virtual void notifyControl();

#ifdef OMANIMATOR
private:
	static OMMap<OMString, int> m_AppName2HasControlMap;
	static OMMap<OMString, TOMUIState> m_AppName2MyStateMap;

	void setControlOfCurrentApplication(int a_nHasControl);
	void setMyStateOfCurrentApplication(TOMUIState a_State);
	TOMUIState getMyStateOfCurrentApplication();

public:
	void removeInfoOfSpecificSocket(void* pSocket);
#endif
};
#endif 


//
// $Log: tomstep.h $
// Revision 1.48  2007/05/29 12:01:55  ilelpa
// Timer service for RTC
// Revision 1.47.1.1  2007/04/01 07:39:48  ilelpa
// Duplicate revision
// Revision 1.46  2007/03/11 13:14:46  ilgiga
// Change copyright comment
// Revision 1.45  2007/03/04 15:07:38  ilgiga
// Telelogic instead of i-Logix
// Revision 1.44  2006/10/31 08:58:55  ccohen
// support running multiple animation processes.
// Revision 1.43  2004/05/27 13:06:25  eldad
// Support LogCmd tracing command
// Revision 1.42.1.1  2004/05/11 08:09:09  eldad
// Duplicate revision
// Revision 1.41  2004/01/18 10:18:53  eldad
// to main branch
// Revision 1.40.1.2  2004/01/13 16:23:45  eldad
// Search path TOMPATH for the input command
// Revision 1.40  2002/08/06 08:25:03  Eldad
// Fixed warnings in Solaros Adaptor.
// Revision 1.39.1.1  2002/07/29 09:30:40  Eldad
// Duplicate revision
// Revision 1.38  2002/07/15 12:29:35  avrahams
// Back to main
// Revision 1.37.2.2  2002/07/04 11:25:20  avrahams
// Cleanup std namespace usage
// Revision 1.37.2.1  2001/05/02 14:50:58  avrahams
// Duplicate revision
// Revision 1.37.3.1  2002/07/29 09:29:21  Eldad
// Revision 1.37  2001/05/02 14:50:58  amos
// fix compilation errors
// Revision 1.36  2001/05/02 12:46:49  amos
// comment statements aftert #endif
// Revision 1.35  2000/07/11 14:51:28  amos
// changes related to modify char* to const char*.
// Revision 1.34  1999/11/08 15:09:40  zvika
// Add DLLs.
// Revision 1.33  1999/08/11 17:03:24  beery
// adding timestamp in tracer mode
// Revision 1.32  1999/02/18 11:27:15  yachin
// Fix regression on initial call stack entry
// Revision 1.31  1999/02/16 05:57:02  yachin
// Speed up of constructors
// Revision 1.30  1998/12/17 14:36:42  ofer
// handle aomdbgstop message which is breakpoint from debugger
// Revision 1.29  1998/11/23 17:41:33  beery
// Revision 1.28  1998/11/22 14:18:29  beery
// Revision 1.27  1998/11/19 17:58:51  beery
// Revision 1.26  1998/11/17 12:27:23  beery
// Revision 1.25  1998/08/02 15:06:39  beery
// changing boolean->OMBoolean
// Revision 1.24  1998/03/25 05:04:56  yachin
// Revision 1.23  1997/08/07 12:18:06  yachin
// Notify user when "input" command fails
// Revision 1.22  1997/02/12 11:15:42  yachin
// Rewrite of TOMProxyItem(...)
// Revision 1.21  1997/01/21 11:08:51  yachin
// changed _int32 to int
// Revision 1.20  1996/12/26 09:48:45  yachin
// Revision 1.19  1996/12/25 13:38:33  yachin
// Multi-Threading first shot
// Revision 1.18  1996/11/24 12:40:45  yachin
// Revision 1.17  1996/11/14 08:10:32  yachin
// Revision 1.16  1996/11/11 11:54:28  yachin
// Support multi-thread part I
// Revision 1.15  1996/11/05 13:45:37  yachin
// Change getType to non virtual add myType attribute
// Revision 1.14  1996/10/15 13:29:59  yachin
// add mask and break options to interface
// Revision 1.13  1996/10/09 07:37:12  yachin
// Revision 1.12  1996/09/30 10:05:31  yachin
// Revision 1.11  1996/09/30 06:31:22  yachin
// Fix setInput to be public and not produce message on init
// Revision 1.10  1996/09/29 08:04:21  yachin
// In ANIMATION: Read from input file before "promting to user"
// Revision 1.9  1996/09/19 08:04:08  yachin
// Proper deletion when animation is terminated
// Revision 1.8  1996/09/16 11:10:06  ofer
// passControltoUser --> passControlToUser (tomstep.cpp/h)
// Revision 1.7  1996/09/16 09:28:38  yachin
// Revision 1.6  1996/09/01 11:30:02  yachin
// Revision 1.5  1996/09/01 06:51:58  ofer
// Revision 1.4  1996/08/12 12:28:51  yachin
// Unified Interface for "file" and "stdin". seperated show from trace
// Revision 1.3  1996/08/08 08:23:31  yachin
// Revision 1.2  1996/08/06 12:55:58  yachin
// Revision 1.1  1996/08/06 12:53:26  yachin
// Initial revision
//
