#ifndef tomstate_H
#define tomstate_H "$Id: tomstate.h 1.20 2007/03/11 13:14:46 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tomstate.h $
//	file version:	$Revision: 1.20 $
//
//	purpose:	TOM State - the state of an OMReactive object
//	Assumptions: 
//		1. A TOMInstance not interested is "states" 
//			has a TOMState * == NULL.
//		2. A TOMInstance which becomes interested in states
//			
//
//	author(s):	  Yachin Pnueli
//	date started:	28.7.96
//	date changed:	$Date: 2007/03/11 13:14:46 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//

#include "toxf.h"
//
//	TOMState - a proxy item which "remembers" the state of an object
//
class RP_ANIM_DLL OMHandleList: public OMList<OMHandle *> {
public:
	~OMHandleList() { removeAll(); }
	void removeAll() {
		for(OMIterator<OMHandle *> il(this); *il; il++)
			delete (*il);
		OMList<OMHandle *>::removeAll();
	}
};

class TOMInstance;
class OMSData;

class RP_ANIM_DLL TOMState {
	int inBehavior;
	OMHandleList currentStates;	// States we are "in"
	OMHandleList oldStates;		// States we left in current step
	OMHandleList currentTransitions;// Trans. taken in current step
	OMHandleList activeTransitions; // Trans. started but not concluded
//	OMHandleList terminations;	// Termination connectors we are in
	OMBoolean terminated;	// Currently we do not highlight the 
	// termination connectors so we do not need a list - just a OMBoolean
	TOMInstance * myInstance;			// The instance to which I belong
	OMHandle * current;

	OMBoolean updateList(OMHandleList& , OMHandleList& , OMHandle *);
public:
	virtual ~TOMState() { }
	TOMState(TOMInstance * theInstance) { 
		myInstance = theInstance;
		terminated = FALSE;
		inBehavior = 0;
	}

	//
	// Methods to allow notifications to "my observers"
	//
	OMHandle * getCurrent() const { return current; }
	OMList<OMHandle *>* getCurrentStates() {
		return &currentStates;	// States we are "in"
	}
	OMList<OMHandle *>* getOldStates() {
		return &oldStates;		// States we left in current step
	}
	OMList<OMHandle *>* getCurrentTransitions() {
		return &currentTransitions;// Trans. taken in current step
	}
	OMList<OMHandle *>* getActiveTransitions() {
		return &activeTransitions; // Trans. started but not concluded
	}
//	OMList<OMHandle *>* getTerminations() {
//		return &terminations;	// Termination connectors we are in
//	}
	OMBoolean isTerminated() const { return terminated; }

	//
	// Methods for Notifying "me" about changes in "myReal"
	//
	void enteredState(OMSData * s, OMSPosition p);

	void exitedState(OMSData * s, OMSPosition p);

	void terminationReached(OMSData *, OMSPosition) {
		// Get the state
		// current = s->getChar(p);
		// terminations.add(current);
		terminated = TRUE;
	}

	void startedTransition(OMSData * s, OMSPosition p) {
		// Get the state
		current = s->getChar(p);
		// add it to the list of current states
		activeTransitions.add(current);
	}

	void endedTransition(OMSData * s, OMSPosition p);

	void resetInBehaviorStepCounter() { inBehavior = 0; }
	OMBoolean notInBehaviorStep() const { return inBehavior==0; }
	void endBehaviourStep() { if (inBehavior>0) inBehavior--; }
	void startBehaviourStep();

	void startNullStep();

	void handleStateConfiguration(OMSData * s, OMSPosition& p);

	OMBoolean isSameCurrentStates(TOMState& state);

};

//
// $Log: tomstate.h $
// Revision 1.20  2007/03/11 13:14:46  ilgiga
// Change copyright comment
// Revision 1.19  2007/03/04 15:07:37  ilgiga
// Telelogic instead of i-Logix
// Revision 1.18  2005/01/19 12:53:29  eldad
// patch for 79582 fix.
// Revision 1.17  2001/05/10 08:21:15  amos
// fix the state message handling algorithm in TOMInstance::handleStateConfiguration()
//   the new algorithm updata the state when the existing state is out-of-date as well as when there is no state.
// Revision 1.16  2000/12/25 10:27:27  amos
// move to warning level 4
// Revision 1.15.1.1  2001/05/09 18:24:20  sasha
// Added new oprtation isSameCurrentStates for compare TOM states.
// Revision 1.15  2000/01/13 09:50:46  amos
// support animation of Null Transition
// Revision 1.14  1999/11/08 15:09:40  zvika
// Add DLLs.
// Revision 1.13  1998/08/02 15:06:38  beery
// changing boolean->OMBoolean
// Revision 1.12  1996/12/08 11:55:25  yachin
// Revision 1.10  1996/12/03 13:24:56  yachin
// Revision 1.9  1996/12/03 07:12:35  yachin
// Fixed "triggered op/notify behavior step" bug
// Revision 1.8  1996/11/24 12:40:45  yachin
// Revision 1.7  1996/10/09 07:37:11  yachin
// Revision 1.6  1996/09/18 13:00:49  yachin
// Revision 1.5  1996/09/17 13:43:01  yachin
// Revision 1.4  1996/09/16 09:28:37  yachin
// Revision 1.3  1996/08/29 11:27:38  ofer
// Revision 1.2  1996/08/06 12:55:57  yachin
// Revision 1.1  1996/08/06 12:53:25  yachin
// Initial revision
//

#endif
