#ifndef tomproxy_H
#define tomproxy_H "$Id: tomproxy.h 1.64 2007/03/11 13:14:45 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tomproxy.h $
//	file version:	$Revision: 1.64 $
//
//	purpose:	Super class of all Tracer "proxy" items
//	Responsibilities:
//		1. Maintain the name
//		2. Maintain my Real
//		3. Maintain the interest mask
//		4. Handle the registration/deregistration of observers
//	Paradigms:
//	1. When an object is created it gets a name. This name does not change
//	except in two cases:
//		1. An instance gets connected to a composite relation
//		2. The user changed the name of the instance 
//			(not supported in relaeas 1)
//	2. When an object is created it gets a "real" - the object it "proxies"
//		The real does not change. When "myReal" gets deleted so does "this"
//	3. The actual interest mask of an item is the "subjects" in which it is 
//		interested. It is composed of the "myMask" variable which is the sum of the interest
//		masks of its observers. +  the things it needs to maintain its own integrity which
//		are sumed in a virtual function "myDefaultMask()".
//		What an object sends it "real" as the interest mask is myMask + myDefaultMask()
//	4. Registration/Deregistration in TRACE mode is trivial since we have
//		just a single observer - tomProxyConsole. In Animate mode it
//		involves maintaning a list of observers + their masks
//		and correctly updating the interest maks of "this"

//		
//
//	author(s):	  Yachin Pnueli
//	date started:	20.5.96
//	date changed:	$Date: 2007/03/11 13:14:45 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//

#include "toxf.h"
#include "tomvisitor.h"
#include "tomrefresh.h"
//
//	TOMProxyItem	-	The Base class of Trace items
//

//
//	Definitions required for "observer" mechanism
//
class TOMUniversalObserver;
class TOMShowObserver;
class TOMRefresh;
class TOMSData;

class AnimMessage;

//
//	TOMUniversalObserveres are always regitered with their masks
//
class RP_ANIM_DLL TOMMaskedObserver {
	OMInterestMask mask;
	TOMUniversalObserver * p;
public:
	TOMMaskedObserver(TOMUniversalObserver * theP, OMInterestMask theMask=OMNoInterest) {
		mask = theMask; p = theP;
	}
	void setMask(OMInterestMask theMask=OMNoInterest) {
		mask = theMask;
	}
	OMInterestMask getMask() const { return mask; }
	TOMUniversalObserver* getObserver() const { return p; }
};

class TOMPackage;
class TOMProxyItem;

class RP_ANIM_DLL TOMProxyItem {
private:
	static short MagicCookie;
	short myCookie;
	friend class TOMRefresh;
protected:
	OMInterestMask	myMask;			// The subjects I'm interested in
	OMInterestMask  mySavedMask;	// The subject I was interested when watching
	OMInterestMask  myLastSentMask;	// The subject that myReal was informaed about
	void*			myReal;			// The real item I "proxy"
	char*			myName;			// The 'item's'first name
	const TOMProxyItem* myContext;	// The base for the "family/full" name
	OMProxyType myType;
	enum TOMSilentMode { TOMInSilent, TOMInLoud };
	TOMSilentMode mySilentMode;		// the current mode
	TOMRefresher myRefresher; 
	void*			mySocket;		// The socket to the application i communicate with.
	char*			myAppName;		// The name of the Application i'm running in.

	// The lists of observers and show observers
	OMList<TOMMaskedObserver *> observerList;
	OMList<TOMShowObserver *> showObserverList;

	void setName(char * theName,
				 OMProxyType theType,
				 const TOMProxyItem * theContext) {
		myType = theType;
		myName = theName;
		myContext = theContext;
	}
	void setReal(OMInterestMask theMask, void * theReal);

	// (Saved) Interest mask accessors
	virtual int myDefaultMask() const { return OMNoInterest; }
public:
	int getRealMask() const;
	int getFullRealMask() const { return getRealMask() | myDefaultMask(); }
	void setRealMask(int mask);
protected:
	int getMask() const { return myMask.toInt(); }
	int getFullMask() const { return getMask() | myDefaultMask(); }
	int getSavedMask() const { return mySavedMask.toInt(); }
	int getFullSavedMask() const { return getSavedMask() | myDefaultMask(); }
   	OMBoolean virtual isInteresting(unsigned int theMask = OMAllInterest) const
	{ 
		return myMask.isInteresting(theMask);
	}
	// (Saved) Interest mask mutator
	virtual void setInterestMask(OMInterestMask newMask);
	virtual void setSavedInterestMask(OMInterestMask newMask) { mySavedMask = newMask; }

	void _registerObserver(TOMUniversalObserver* , OMInterestMask);
	void _updateObserver(TOMUniversalObserver* ,
						TOMMaskedObserver*,
						OMInterestMask);
	void _deregisterObserver(TOMMaskedObserver*);

	void clearObserversNotify();
	void clearObserversWithoutNotify();

	virtual void _showYourself(TOMUniversalObserver* , int&) { }

	// Constructors - can only be used by derived classes
	TOMProxyItem(char * theName,
				 OMProxyType theType = omProxyItem,
				 const TOMProxyItem * theContext=OMSystemContext);

	TOMProxyItem(void * theReal,
				 char * theName,
				 OMProxyType theType = omProxyItem,
				 OMInterestMask theMask=OMNoInterest,
				 const TOMProxyItem * theContext=OMSystemContext);
public:
	// Destructors
	virtual ~TOMProxyItem();

	// Name methods
	char * getFirstName() const { return myName; }
	virtual OMString& outputFirstName(OMString& s) const { 
		s+=myName; return s; }
	virtual OMString& outputFullName(OMString& s, 
			const TOMProxyItem * /* theContext */ = OMSystemContext) const {
		return outputFirstName(s);
	}
	virtual TOMPackage* getPackage() const { return NULL; }

	// Simple accessors
	const TOMProxyItem * getContext() const { return myContext; }
	void * getReal() const { return myReal; }
	OMProxyType getType() const { return myType; }

	OMBoolean isValid() const; // Non virtual so we do not rely on exceptions

	// Observer Handling methods
	void registerToTrace(TOMProxyItem * base);

	// add obs with theMask to myObserverList
	// WARNINNG if obs is already registered - this == "reRegister"
	virtual void registerObserver(TOMUniversalObserver* obs,
									OMInterestMask theMask);

	// reregister obs with newMask. obs may already be registered
	// or may be a new observer.
	// If newMask does not include "real" interest fields
	// reRegister will simply deregister obs
	virtual void reRegisterObserver(TOMUniversalObserver* obs,
									OMInterestMask newMask);
	// add subjects of newMask to obs. if obs is not registered
	// this also registers it.
	virtual void addToObserver(TOMUniversalObserver* obs,
									OMInterestMask newMask);
	// subtruct subjects of newMask from obs. if obs is not registered
	// this does nothing. if subtraction leaves obs with no "real"
	// interest subjects this deregisters it.
	virtual void subtractFromObserver(TOMUniversalObserver* obs,
									OMInterestMask newMask);
	// deregister obs. The mask is used only in TOMClass items
	// see their for alternatives to OMAllInterest
	virtual void deregisterObserver(TOMUniversalObserver * obs,
									OMInterestMask mask = OMAllInterest);
	// Show observer handling
	void registerShowObserver(TOMShowObserver* obs){
		showObserverList.add(obs);
	}
	void deregisterShowObserver(TOMShowObserver * obs) {
		showObserverList.remove(obs);
	}


	// Handle message from s[p] on.
	// OverRide by derived classes - Should never be here
	virtual void handleMessage(OMNotify, TOMSData*, OMSPosition) {}
	virtual void handleMessage_safety(OMNotify *, TOMSData*, OMSPosition) {}
	virtual void handleMessage(AnimMessage*) {}

	virtual OMBoolean showYourself(TOMUniversalObserver* obs, int theMask);
//	virtual OMBoolean showYourself(TOMUniversalObserver* obs);

	void notifyLostFocus();

	// For debugging only
	void showObservers(OMList<TOMMaskedObserver *>*& theObserverList,
					OMList<TOMShowObserver *>*&theShowObserverList,
					OMInterestMask& theMask);

	// accept a visitor, execute its wishes
	virtual void accept(TOMProxyVisitor1Arg & /* visitor */) {};

	// go to silent mode
	virtual void goSilent(OMInterestMask newMask = OMExistInterest );
	// return from silent mode, restore the original interesting mask
	virtual void goLoud(OMInterestMask newSavedMask = OMNoInterest);
	OMBoolean inSilentMode() const { 
		return mySilentMode == TOMInSilent; 
	}
	virtual OMBoolean refresh();

	const OMList<TOMMaskedObserver *> & getObserverList() const {
		return 	observerList;
	
	}

	TOMMaskedObserver * getObserver(TOMUniversalObserver* observer) const;

	void* getMySocket() const { return mySocket; } 
	void setMySocket(void* pSocket) { mySocket = pSocket; }

	char* getMyAppName() const { return myAppName; }
	void setMyAppName(char* pAppName);
};

RP_ANIM_DLL OMBoolean tomIsValidItem(const void * const i);

RP_ANIM_DLL omostream& operator<<(omostream& os, TOMProxyItem *item);


inline void notifyUnexpectedMessage(OMNotify msgCode) {
	OMString msg = "Received unexpected message of type ";
	msg +=omnotify2String(msgCode);
	tomSendWarning(msg);
}


//
// $Log: tomproxy.h $
// Revision 1.64  2007/03/11 13:14:45  ilgiga
// Change copyright comment
// Revision 1.63  2007/03/04 15:07:36  ilgiga
// Telelogic instead of i-Logix
// Revision 1.62  2006/10/31 08:58:54  ccohen
// support running multiple animation processes.
// Revision 1.61  2003/10/28 12:59:03  amos
// Revision 1.60  2002/07/29 09:28:36  Eldad
// Merge 1.58.2.1 + 1.59
// Revision 1.59  2002/07/15 12:29:33  avrahams
// Back to main
// Revision 1.58.1.2  2002/07/04 11:22:00  avrahams
// Cleanup std namespace usage
// Revision 1.58.1.1  2001/10/01 10:21:31  avrahams
// Duplicate revision
// Revision 1.58.2.1  2002/07/29 09:27:06  Eldad
// Revision 1.58  2001/10/01 10:21:31  Eldad
// 1.57.1.2 to main branch
// Revision 1.57.1.2  2001/09/26 00:48:45  Eldad
// Changed some of the erros to warnings that are not to be shown in popup 
// message box.
// Revision 1.57.1.1  2001/05/16 08:56:46  Eldad
// Duplicate revision
// Revision 1.56  2001/05/06 12:31:46  Eldad
// Removed the word Error from line 245.
// Revision 1.55  2000/12/25 10:18:28  amos
// move to warning level 4
// Revision 1.54  2000/01/20 07:08:00  yachin
// Fix spelling mistake
// Revision 1.53  1999/11/08 15:09:39  zvika
// Add DLLs.
// Revision 1.52  1999/06/18 09:07:48  beery
// due to lazy evaluation, make sure that new package/class/classevent are observed my the console 
// so when a new object or event are created they "inherite" their initial mask from their logical parent
// Revision 1.51  1999/02/16 05:57:01  yachin
// Speed up of constructors
// Revision 1.50  1998/11/23 17:41:14  beery
// Revision 1.49  1998/11/22 14:18:12  beery
// Revision 1.48  1998/11/19 17:58:36  beery
// Revision 1.47  1998/11/17 13:50:13  beery
// Revision 1.46  1998/11/17 12:25:36  beery
// Revision 1.45  1998/08/02 15:06:37  beery
// changing boolean->OMBoolean
// Revision 1.44  1998/06/30 09:01:01  yachin
// fix bug 6579 - added magic cookie to TOMProxyItem
// Revision 1.43  1998/05/21 11:24:07  yachin
// Fix bug 5603 (have getPackage return a TOMPackage and not a TOMProxyItem)
// Revision 1.42  1997/08/04 13:40:02  ofer
// TOMProxyItem::getType() MUST return value
// of type OMProxyType  (vc5.0 does not like it)
// tomproxy.h
// Revision 1.41  1997/07/21 06:33:01  yachin
// Added global items to animation part II
// Revision 1.40  1997/02/24 08:32:28  yachin
// Bug fix in tomIsValid
// Revision 1.39  1997/02/18 11:30:49  yachin
// Bug fixes
// Revision 1.38  1997/02/17 12:32:38  yachin
// bug fixes
// Revision 1.37  1997/02/12 11:15:40  yachin
// Rewrite of TOMProxyItem(...)
// Revision 1.36  1997/02/11 12:54:38  yachin
// Adding Name spaces
// Revision 1.35  1997/02/09 12:57:55  yachin
// Bug fix
// Revision 1.34  1997/02/06 13:33:53  yachin
// Switched from try to tomIsValidItem
// Revision 1.33  1997/01/21 11:08:49  yachin
// changed _int32 to int
// Revision 1.32  1996/12/25 13:38:32  yachin
// Multi-Threading first shot
// Revision 1.31  1996/11/24 12:40:44  yachin
// Revision 1.30  1996/11/14 08:10:31  yachin
// Revision 1.29  1996/11/06 08:54:38  yachin
// registerObserver changed to reRegisterObserver
// Revision 1.28  1996/11/05 13:45:36  yachin
// Change getType to non virtual add myType attribute
// Revision 1.27  1996/10/29 08:28:48  yachin
// Revision 1.26  1996/10/24 12:56:40  yachin
// Rewrite of observer registration mechanism + new instance iterators
// Revision 1.25  1996/10/15 13:29:58  yachin
// add mask and break options to interface
// Revision 1.24  1996/10/10 08:01:28  yachin
// Revision 1.23  1996/10/09 07:37:11  yachin
// Revision 1.22  1996/10/01 06:56:23  yachin
// Fixing the "show class all" bug
// Revision 1.21  1996/09/30 10:05:30  yachin
// Revision 1.20  1996/09/25 13:45:46  yachin
// Minor Bug fixes
// Revision 1.19  1996/09/17 13:46:03  yachin
// Revision 1.18  1996/09/16 09:28:36  yachin
// Revision 1.17  1996/09/09 07:25:54  yachin
// Fix bug in name2item
// Revision 1.16  1996/09/08 13:28:59  yachin
// Registeration of items which do not yet exist
// Revision 1.15  1996/09/05 13:35:57  yachin
// Revision 1.14  1996/09/04 13:16:12  yachin
// Connect with Israel
// Revision 1.13  1996/09/03 12:01:16  yachin
// Alow show #callStack
// Revision 1.12  1996/08/29 11:25:58  ofer
// Revision 1.11  1996/08/15 08:42:41  yachin
// Revision 1.10  1996/08/14 12:40:25  yachin
// Seperate TOM Masks from AOM Masks. Fix bugs with attr. and states
// Revision 1.9  1996/08/12 12:28:50  yachin
// Unified Interface for "file" and "stdin". seperated show from trace
// Revision 1.8  1996/08/08 08:23:30  yachin
// Revision 1.7  1996/08/06 12:52:09  yachin
// Version for Prototype 4
// Revision 1.6  1996/07/22 11:30:34  yachin
// Revision 1.5  1996/07/10 05:50:10  yachin
// Reprecussion of reorganizatio nof AOM
// Revision 1.4  1996/07/04 12:38:52  yachin
// Bug fixes and handleing static methods
// Revision 1.3  1996/06/23 11:18:06  yachin
// Revision 1.2  1996/06/19 10:21:32  yachin
// Revision 1.1  1996/06/17 05:40:52  yachin
// Initial revision
//

#endif
