#ifndef tompack_H
#define tompack_H "$Id: tompack.h 1.19 2007/03/11 13:14:45 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tompack.h $
//	file version:	$Revision: 1.19 $
//
//	purpose:	Define the TOMPackage class - the proxy class of a
//				package
//				Main responsibilities:
//				Serve as starting point for name-space searches
//
//	author(s):	Yachin Pnueli
//	date started:	9.2.97
//	date changed:	$Date: 2007/03/11 13:14:45 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1996, 2007
//
#include	"tomproxy.h"

class TOMClass;
class TOMEventClass;
class TOMInstance;
class TOMPackageIterator;
class TOMNameSpaced;

class RP_ANIM_DLL TOMPackage : public TOMProxyItem {
	friend class TOMPackageIterator;
	OMList <TOMClass *> theClasses;
	OMList <TOMEventClass *> theEventClasses;
protected:
	void _showYourself(TOMUniversalObserver*,int& theMask);
	virtual int myDefaultMask() const { return OMParameterInterest; }
public:
	virtual ~TOMPackage();
	TOMPackage(char * name):TOMProxyItem(name,omProxyPackage) { setInterestMask(myMask += myDefaultMask()); }
	// name is allocated

	TOMProxyItem* name2Item(char *& name) const;
	TOMClass* name2Class(const OMString& name) const;
	TOMEventClass* name2EventClass(const OMString& name, void* pSocket) const;

	OMList <TOMClass *>* getClasses() { return &theClasses; }
	OMList <TOMEventClass *>* getEventClasses() { return &theEventClasses; }

	void addClass(TOMClass* c);
	void addEventClass(TOMEventClass* c);
	virtual TOMPackage* getPackage() const { return (TOMPackage*)this; } // assumes no package in package

	OMBoolean showYourself(TOMUniversalObserver*, int);
	void registerObserver(TOMUniversalObserver*, OMInterestMask);
	void deregisterObserver(TOMUniversalObserver* obs, OMInterestMask mask = OMAllInterest);
	void reRegisterObserver(TOMUniversalObserver*, OMInterestMask);
	void addToObserver(TOMUniversalObserver*, OMInterestMask);
	void subtractFromObserver(TOMUniversalObserver*, OMInterestMask);

	OMBoolean addBreakPoint(OMNotify theType, const char *theData="");
	TOMProxyItem * getInstanceByReal(void* real);

	void setReal(void* real);
	void handleMessage(OMNotify r, TOMSData* s, OMSPosition p);
	virtual void handleMessage(AnimMessage* msg) { TOMProxyItem::handleMessage(msg); }

	// accept a visitor, and execute its wishes
	virtual void accept(TOMProxyVisitor1Arg & visitor);

	void name2Classes(const OMString& name, OMList<TOMClass*>& classes) const;

};


class RP_ANIM_DLL TOMPackageIterator : public OMIterator<TOMInstance *> {
private:
	OMIterator<TOMClass *> classIter;
	void advanceToNextNonEmptyClass();
public:
 	TOMPackageIterator(TOMPackage &p) { reset(&p); }
 	TOMPackageIterator(TOMPackage *p) { reset(p); }
	
	TOMPackageIterator& increment(); 

	TOMPackageIterator& operator++()	{ return increment(); }

	TOMPackageIterator operator++(int)	{ 
	  TOMPackageIterator T = *this ;	// save status prior to increment
	  increment();
	  return T; 
	}
	void reset(TOMPackage *p);
	void reset();
};



//
// $Log: tompack.h $
// Revision 1.19  2007/03/11 13:14:45  ilgiga
// Change copyright comment
// Revision 1.18  2007/03/04 15:07:35  ilgiga
// Telelogic instead of i-Logix
// Revision 1.17  2006/10/31 08:58:53  ccohen
// support running multiple animation processes.
// Revision 1.16  2002/11/06 12:08:39  Eldad
// 1.15.1.2 to main branch.
// Revision 1.15.1.2  2002/10/22 15:37:01  Eldad
// Setting the package mask to parameter interest solves the bug.
// Revision 1.16  2002/10/22 15:36:00  Eldad
// Setting the package mask to parameter interest solves the bug.
// Revision 1.15  2002/08/06 08:25:02  Eldad
// Fixed warnings in Solaros Adaptor.
// Revision 1.14  1999/11/08 15:09:38  zvika
// Add DLLs.
// Revision 1.13  1999/10/12 13:33:02  yachin
// Fix bugs
// Revision 1.12  1999/06/18 09:07:46  beery
// due to lazy evaluation, make sure that new package/class/classevent are observed my the console 
// so when a new object or event are created they "inherite" their initial mask from their logical parent
// Revision 1.11  1999/02/18 11:27:13  yachin
// Fix regression on initial call stack entry
// Revision 1.10  1999/02/16 05:57:00  yachin
// Speed up of constructors
// Revision 1.9  1998/11/19 17:58:01  beery
// Revision 1.8  1998/11/17 12:18:30  beery
// Revision 1.7  1998/08/02 15:06:36  beery
// changing boolean->OMBoolean
// Revision 1.6  1998/05/21 11:24:07  yachin
// Fix bug 5603 (have getPackage return a TOMPackage and not a TOMProxyItem)
// Revision 1.5  1997/07/20 11:36:40  yachin
// Adding globals to animation
// Revision 1.4  1997/02/21 08:56:44  yachin
// Added show #all events
// Revision 1.3  1997/02/19 11:19:56  yachin
// Add isAnimationActive mode to all observer operations
// Revision 1.2  1997/02/12 11:15:40  yachin
// Rewrite of TOMProxyItem(...)
// Revision 1.1  1997/02/11 13:05:41  yachin
// Initial revision
//

#endif
