#ifndef tomout_H
#define tomout_H "$Id: tomout.h 1.23 2007/03/11 13:14:44 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tomout.h $
//	file version:	$Revision: 1.23 $
//
//	purpose: define the TracerOutput class - responsible for tracer outputs	
//
//	author(s):	Yachin Pnueli
//	date started:	22.5.96
//	date changed:	$Date: 2007/03/11 13:14:44 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//
#include "toxf.h"

// Time options
const unsigned int  OMwithNoTime		=	0x00000000;
const unsigned int  OMwithRawTime		=	0x00000001;
const unsigned int  OMwithFormattedTime	=	0x00000002;

class RP_ANIM_DLL TOMTOMask {
	int mask;
public:
	TOMTOMask(int theMask = OMNoInterest) { setMask(theMask); }
	void setMask(int newMask) { mask = newMask; }
	int withFormattedTime() { return mask & OMwithFormattedTime; }
	int withRawTime() { return mask & OMwithRawTime; }
	int withNothing() { return !mask; }

};

class OMOSMutex;

class RP_ANIM_DLL TOMTracerOutput {
	static OMOSMutex* mutex;
	static OMBoolean mayOutput;
	static OMString buffer;
	OMList<omostream *> outList;
	TOMTOMask mask;

	void endOutput();
	void output(const char *);
	void output(const TOMProxyItem *);
	void actuallyPrintHeader();
	void printHeader(OMBoolean withHeader=TRUE, OMBoolean withIndent=TRUE);
	void outputString(const char *msg, OMBoolean withIndent=TRUE);
public:
	~TOMTracerOutput();
	TOMTracerOutput() { mayOutput = TRUE; }
	void registerItem(omostream *s) { outList.add(s); }
	void deregisterItem(omostream *s, OMBoolean toDelete=TRUE);
	void setTraceTime(int newMask) { mask.setMask(newMask); }

	void rawOutput(const char *msg,OMBoolean withCout = TRUE);
	void notifyMessage(const char * msg);
	void notify(OMString& msg, OMBoolean withIndent=TRUE) {
		notify(msg.GetBuffer(0), withIndent); 
	}
	void notify(const char * msg, OMBoolean withIndent=TRUE);
	void notify(const TOMProxyItem *p,
				OMString& msg,
				OMBoolean withIndent=TRUE) {
		notify(p, msg.GetBuffer(0), withIndent); 
	}
	void notify(const TOMProxyItem *p, 
				const char *msg,
				OMBoolean withIndent=TRUE);

	void allowOutput();
	void disallowOutput();

};


//
// $Log: tomout.h $
// Revision 1.23  2007/03/11 13:14:44  ilgiga
// Change copyright comment
// Revision 1.22  2007/03/04 15:07:35  ilgiga
// Telelogic instead of i-Logix
// Revision 1.21  2002/07/15 12:29:33  avrahams
// Back to main
// Revision 1.20.1.2  2002/07/04 11:18:17  avrahams
// Cleanup std namespace usage
// Revision 1.20.1.1  1999/11/08 15:09:38  avrahams
// Duplicate revision
// Revision 1.20  1999/11/08 15:09:38  zvika
// Add DLLs.
// Revision 1.19  1999/08/11 17:03:16  beery
// adding timestamp in tracer mode
// Revision 1.18  1998/08/02 15:06:35  beery
// changing boolean->OMBoolean
// Revision 1.17  1998/04/13 08:08:50  ofer
// remove forward declaration of class ostream 
// since STL define it different and in any case toxf.h has include
// to iostream
// Revision 1.16  1997/02/26 06:42:12  yachin
// Add mutex on TOMOutput
// Revision 1.15  1997/01/21 11:08:48  yachin
// changed _int32 to int
// Revision 1.14  1997/01/19 07:37:49  yachin
// Multi-threading addenda
// Revision 1.13  1996/11/24 12:40:43  yachin
// Revision 1.12  1996/11/05 07:20:19  yachin
// Fixed crash in "end animation"
// Revision 1.11  1996/10/10 08:01:28  yachin
// Revision 1.10  1996/09/16 12:44:42  ofer
// deregistration changed to allow non closed ostreams
// like we are using in o-mate (output window)(tomout.cpp/h)
// Revision 1.9  1996/08/28 05:38:08  ofer
// Revision 1.8  1996/08/12 12:28:50  yachin
// Unified Interface for "file" and "stdin". seperated show from trace
// Revision 1.7  1996/08/06 12:52:08  yachin
// Version for Prototype 4
// Revision 1.6  1996/07/22 11:30:33  yachin
// Revision 1.5  1996/07/03 12:45:52  yachin
// Fixing bugs for "const" and "static
// enhancements for attributes and indentation
// Revision 1.4  1996/06/26 12:46:00  yachin
// Put header message and fix some bugs
// Revision 1.3  1996/06/23 11:18:05  yachin
// Revision 1.2  1996/06/19 10:21:31  yachin
// Revision 1.1  1996/06/17 05:40:50  yachin
// Initial revision
//

#endif
