#ifndef tomother_H
#define tomother_H "$Id: tomother.h 1.37 2007/03/11 13:14:44 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tomother.h $
//	file version:	$Revision: 1.37 $
//
//	purpose:	TOM classes of "other" items (excludeing classes and instances)
//
//	author(s):	  Yachin Pnueli
//	date started:	28.5.96
//	date changed:	$Date: 2007/03/11 13:14:44 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//
#include "tomproxy.h"
#include <oxf/omstack.h>

class TOMInstance;
//
//	TOMCallStack	-	The proxy
//
class RP_ANIM_DLL TOMCallStack : public TOMProxyItem {
	static TOMCallStack * current;
	static char * indentationBuffer;
	static int methodType2Interest(OMMethodType typ);
	OMStack<TOMProxyItem *> instanceStack;
	OMStack<OMSData *> methodStack;
	OMStack<OMMethodType> typeStack;

	virtual void _showYourself(TOMUniversalObserver* , int&);
	char * _getIndentation();
public:
	virtual ~TOMCallStack();
	TOMCallStack(void * theReal, OMInterestMask theMask=OMNoInterest);

	void handleMessage(OMNotify r, TOMSData* s, OMSPosition p);
	void handleMessage_safety(OMNotify * r, TOMSData* s, OMSPosition p);
	virtual void handleMessage(AnimMessage* msg) { TOMProxyItem::handleMessage(msg); }

	static char *getIndentation() { 
		if (current)
			return current->_getIndentation();
		else
			return (char *)("");
	}
	void replaceItemByDestroyed(TOMInstance* destroyed);

	// accept a visitor, and execute its wishes
	virtual void accept(TOMProxyVisitor1Arg & visitor);

	OMSData* getTopMarker(); 
	static OMSData* getCurrentCallstackMarker();
private:
	void incIndentCount() { ++indentCounter; }
	void decIndentCount() { if (indentCounter > 0) --indentCounter; }
	int indentCounter;

};

//
//	TOMEventQueue	-	The proxy
//
class RP_ANIM_DLL TOMEventQueue : public TOMProxyItem {
	void message2Event(	TOMSData* s, OMSPosition& p,
						OMString& eventString, void*& eventId ) const;
	void readEvent(TOMSData* s, OMSPosition& p,
		TOMInstance *& sender, TOMInstance *& receiver,
		OMString& eventString, void*& eventId ) const;
	void readTimeoutEvent(TOMSData* s, OMSPosition& p,
						TOMInstance *& sender,
						OMString& eventString, void*& eventId ) const;
protected:
	virtual void _showYourself(TOMUniversalObserver* , int&);
public:
	virtual ~TOMEventQueue() { }
	TOMEventQueue(void * theReal, OMInterestMask theMask=OMNoInterest);
	
	void handleMessage(OMNotify r, TOMSData* s, OMSPosition p);
	virtual void handleMessage(AnimMessage* msg) { TOMProxyItem::handleMessage(msg); }

	// accept a visitor, and execute its wishes
	virtual void accept(TOMProxyVisitor1Arg & visitor);
};

//
// $Log: tomother.h $
// Revision 1.37  2007/03/11 13:14:44  ilgiga
// Change copyright comment
// Revision 1.36  2007/03/04 15:07:34  ilgiga
// Telelogic instead of i-Logix
// Revision 1.35  2004/01/14 10:24:23  eldad
// Instead of using the instanceStack for indent - use a special counter
// Revision 1.34  2004/01/07 14:09:55  eldad
// Back to main branch.
// Revision 1.33.1.2  2004/01/04 15:37:41  eldad
// Added a service to get the current top callstack marker.
// Revision 1.33  2002/08/06 08:25:02  Eldad
// Fixed warnings in Solaros Adaptor.
// Revision 1.32  2000/07/19 13:24:41  beery
// Comply with Solaris strict checking of assign "" to char*
// Revision 1.31  2000/07/12 06:54:24  amos
// changes related to modify char* to const char*.
// Revision 1.30  1999/11/08 15:09:38  zvika
// Add DLLs.
// Revision 1.29  1999/02/16 05:56:59  yachin
// Speed up of constructors
// Revision 1.28  1998/11/22 14:17:54  beery
// Revision 1.27  1998/11/19 17:57:17  beery
// Revision 1.26  1998/11/17 12:18:03  beery
// Revision 1.25  1998/08/18 11:59:36  ofer
// set metod ommethodType2Interest to be static memeber
// function of TOMClass ( the cad-ul 2.2.6 compiler did not like
// global function) tomother.cpp/h
// Revision 1.23  1997/07/21 06:33:00  yachin
// Added global items to animation part II
// Revision 1.22  1997/02/12 11:15:40  yachin
// Rewrite of TOMProxyItem(...)
// Revision 1.21  1997/01/21 11:08:48  yachin
// changed _int32 to int
// Revision 1.20  1996/12/23 11:51:12  yachin
// Add ids to events
// Revision 1.19  1996/11/24 12:40:42  yachin
// Revision 1.18  1996/11/11 11:54:26  yachin
// Support multi-thread part I
// Revision 1.17  1996/11/05 13:45:36  yachin
// Change getType to non virtual add myType attribute
// Revision 1.16  1996/10/10 08:01:27  yachin
// Revision 1.15  1996/10/09 07:37:10  yachin
// Revision 1.14  1996/09/19 08:04:08  yachin
// Proper deletion when animation is terminated
// Revision 1.13  1996/09/16 09:28:35  yachin
// Revision 1.12  1996/09/04 13:16:12  yachin
// Connect with Israel
// Revision 1.11  1996/09/03 12:01:16  yachin
// Alow show #callStack
// Revision 1.10  1996/08/29 11:45:34  ofer
// Revision 1.9  1996/08/08 08:23:30  yachin
// Revision 1.8  1996/08/06 12:52:08  yachin
// Version for Prototype 4
// Revision 1.7  1996/07/10 05:50:10  yachin
// Reprecussion of reorganizatio nof AOM
// Revision 1.6  1996/07/03 12:45:51  yachin
// Fixing bugs for "const" and "static
// enhancements for attributes and indentation
// Revision 1.5  1996/06/30 07:57:40  yachin
// Bug fix for case of none interesting call stack items/event senders/receivers
// Revision 1.4  1996/06/24 11:19:36  yachin
// Removed TOMTimer - currently not needed
// Revision 1.3  1996/06/20 10:23:11  yachin
// Revision 1.2  1996/06/19 10:21:30  yachin
// Revision 1.1  1996/06/17 05:40:49  yachin
// Initial revision
//

#endif
