#ifndef tommsg_H
#define tommsg_H "$Id: tommsg.h 1.36 2007/03/11 13:14:43 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tommsg.h $
//	file version:	$Revision: 1.36 $
//
//	purpose: define the TOMMessage classand its sub classes
//
//	author(s):	Yachin Pnueli
//	date started:	26.5.96
//	date changed:	$Date: 2007/03/11 13:14:43 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//

//	An object responsible for correctly printing parameter lists

#include "tomproxy.h"

inline void tomSendError(const TOMProxyItem *p, OMString& msg) {
	OMString s;
	p->outputFullName(s);
	s += msg;
	tomSendError(s);
}


inline void missingError(OMString& errMsg, 
						 const char * thing, 
						 OMSPosition position) {
	// Build the message
	lostSyncError(errMsg,position);
	errMsg +="Missing ";
	errMsg += thing;
	errMsg += "\n";
}


const int ErrorInOMSDParameterList = (-1);
const int SuccessInOMSDParameterList = 0;

// A list of items where the number of items is known A-priori
// Each item is a-priori known to be a singleton or a doubleton.
class RP_ANIM_DLL TOMSList {
protected:
	int count;
	TOMSData *s;
	OMSPosition p;
	TOMSList() {}
	void setValues(OMSData *theS, OMSPosition& position);
	OMSPosition getPosition() const { return p; }
public:
	// Constructors
	TOMSList(OMSData *theS, OMSPosition& position) { 
		setValues(theS,position);
	}
	TOMSList(OMSData *theS) {
		OMSPosition tmp = theS->getFirst();
		setValues(theS,tmp);
	}

	// Get a value (string or pointer to TOMInstance. If encounters errors 
	// returns FALSE and adds error message to errMsg. Else returns True
	OMBoolean getValue(OMString & value, 
					 OMString & errMsg,
					 const TOMProxyItem * context);
	// Get a name and value pair. If encounters errors returns FALSE
	// and adds error message to errMsg. Else returns True
	OMBoolean getNameValuePair(OMString & name, 
							 OMString & value, 
							 OMString & errMsg,
							 const TOMProxyItem * context);

	// Produce a list of name and value pairs. If encounters errors returns 
	// FALSE and adds error message to tmsg. Else returns True
	OMBoolean method2string(OMString& tmsg,
							const char * header, 
							const char * nameValueSeperator,
							const char * itemItemSeperator,
							const char *itemName, 
							const char *tailer,
							const TOMProxyItem * context);

	int getCount() const { return count; }
};


// A method list
class RP_ANIM_DLL TOMSMethod : public TOMSList {
	OMString name;
	void setValues(OMSData *theS, OMSPosition& position) {
		name = theS->safeGetString(position);
		TOMSList::setValues(theS,position);
	}
public:
	// Constructors
	TOMSMethod(OMSData *theS, OMSPosition& position) {
		setValues(theS,position);
	}

	TOMSMethod(OMSData *theS) {
		OMSPosition position = theS->getFirst();
		setValues(theS,position);
	}

	OMString * message2String(const TOMProxyItem * context) {
		OMString * msg = new OMString;
		method2string(*msg, context);
		return msg;
	}
	OMBoolean method2string(OMString& tmsg,
						const TOMProxyItem * context = OMSystemContext) {
		tmsg +=name;
		if (getCount()!=OMSnoParameters)
			return 
				TOMSList::method2string(tmsg,"("," = ",", ",
						"Parameter",")",context);
		else
			return TRUE;
	}
};


// An event list
class TOMSEvent:public TOMSMethod {
public:
	// Constructors
	TOMSEvent(OMSData *theS, OMSPosition& position)
		:TOMSMethod(theS,position) { }

	TOMSEvent(OMSData *theS):TOMSMethod(theS) { }
	OMBoolean method2string(OMString& eventString,void*& eventId,
						const TOMProxyItem * context = OMSystemContext);
};

// A list of call stack items
class RP_ANIM_DLL TOMSCallStackValues : public TOMSList {
public:
	// Constructors
	TOMSCallStackValues(OMSData *theS, OMSPosition& position)
		:TOMSList(theS,position) { }
	TOMSCallStackValues(OMSData *theS):TOMSList(theS) { }
	OMBoolean isLastItem() const { return count==0; }
	void getNextItem(TOMProxyItem *& caller,
						TOMProxyItem *& called, 
						OMSData *& method,
						OMMethodType& methodType);
	void getNextItem(TOMProxyItem *& caller,
						TOMProxyItem *& called, 
						OMString& method,
						OMMethodType& methodType);
	virtual OMBoolean method2string(OMString& tmsg, 
					  const TOMProxyItem * context=OMSystemContext);
};

// A list of event queue items
class RP_ANIM_DLL TOMSEventQueueValues : public TOMSCallStackValues {
public:
	// Constructors
	TOMSEventQueueValues(OMSData *theS, OMSPosition& position):
		TOMSCallStackValues(theS, position) { }
	TOMSEventQueueValues(OMSData *theS):TOMSCallStackValues(theS) { }
	void getNextItem(TOMProxyItem *& caller,
						TOMProxyItem *& called, 
						OMSData *& event);
	void getNextItem(TOMProxyItem *& caller,
						TOMProxyItem *& called, 
						OMString& event,
						void*& eventId);
	void getNextItem(TOMProxyItem *& caller,
						TOMProxyItem *& called, 
						OMString& event) {
		void* unused;
		getNextItem(caller,called,event,unused);
	}
	virtual OMBoolean method2string(OMString& tmsg, 
						const TOMProxyItem * context=OMSystemContext);
};


RP_ANIM_DLL OMBoolean tomItemExists(const TOMProxyItem *i);
RP_ANIM_DLL void tominstance2String(const TOMProxyItem *i, OMString& s,
						const TOMProxyItem * context=OMSystemContext);

inline const char * tominstance2CallString(TOMProxyItem *i) {
	if (tomIsValidItem(i)) {
		// Hope that item is o.k.
		if (isCodeItem(i))
			// This is a "special" AOMInstance
			return getInstaceCallString();
		else if (i->getType()==omProxyClass || i->getType()==omProxyPackage)
			return getClassCallString();
		else
			return getInstaceCallString();
	} else {	// Item is non-existent use getInstaceCallString()
		return getInstaceCallString();
	}
}


//
// $Log: tommsg.h $
// Revision 1.36  2007/03/11 13:14:43  ilgiga
// Change copyright comment
// Revision 1.35  2007/03/04 15:07:33  ilgiga
// Telelogic instead of i-Logix
// Revision 1.34  2000/07/24 09:36:46  amos
// modify TOMList::method2string() to get 'const char*' arguments instead of 'char*' arguments
// Revision 1.33  2000/07/11 13:33:38  amos
// changes related to modify char* to const char*.
// Revision 1.32  1999/11/08 15:09:37  zvika
// Add DLLs.
// Revision 1.31  1999/07/15 13:42:04  yachin
// change 'instanceCallString from '->' to '.'
// Revision 1.30  1999/02/16 05:56:58  yachin
// Speed up of constructors
// Revision 1.29  1998/08/02 15:07:44  beery
// Revision 1.28  1997/07/21 06:33:00  yachin
// Added global items to animation part II
// Revision 1.27  1997/03/31 08:34:17  yachin
// Fix warning in Unix
// Revision 1.26  1997/02/06 13:33:52  yachin
// Switched from try to tomIsValidItem
// Revision 1.25  1997/01/01 13:40:48  yachin
// Revision 1.24  1996/12/23 11:51:10  yachin
// Add ids to events
// Revision 1.23  1996/11/24 12:40:41  yachin
// Revision 1.22  1996/11/06 08:19:32  ofer
// Added new function tomItemExist(TOMProxyItem)
// Added By yachin
// Revision 1.21  1996/10/23 07:48:17  yachin
// Fix interrface to getNextMethod
// Revision 1.20  1996/10/13 11:40:26  yachin
// Bug fixes
// Revision 1.19  1996/10/10 08:01:26  yachin
// Revision 1.18  1996/10/09 07:37:09  yachin
// Revision 1.17  1996/09/26 06:31:27  yachin
// getNextMethod/isLastMethod changed to getNextItem/isLastItem
// Revision 1.16  1996/09/25 10:01:26  yachin
// notifyEventQueueValues added + assorted bug fixes
// Revision 1.15  1996/09/16 09:28:33  yachin
// Revision 1.14  1996/09/08 13:28:58  yachin
// Registeration of items which do not yet exist
// Revision 1.13  1996/09/05 13:35:56  yachin
// Revision 1.12  1996/09/05 07:57:34  ofer
// added new method getNextMethod(...)
// ( different interface used by CallStack observers)
// 
// 
// Revision 1.11  1996/09/04 13:16:11  yachin
// Connect with Israel
// Revision 1.10  1996/08/28 05:38:08  ofer
// Revision 1.9  1996/08/12 12:28:49  yachin
// Unified Interface for "file" and "stdin". seperated show from trace
// Revision 1.8  1996/08/08 08:23:29  yachin
// Revision 1.7  1996/08/06 12:52:07  yachin
// Version for Prototype 4
// Revision 1.6  1996/07/22 11:30:31  yachin
// Revision 1.5  1996/07/15 12:37:55  yachin
// Revision 1.4  1996/07/04 12:38:51  yachin
// Bug fixes and handleing static methods
// Revision 1.3  1996/07/03 12:45:50  yachin
// Fixing bugs for "const" and "static
// enhancements for attributes and indentation
// Revision 1.2  1996/06/19 10:21:29  yachin
// Revision 1.1  1996/06/17 05:40:46  yachin
// Initial revision
//

#endif
