#ifndef tommask_H
#define tommask_H "$Id: tommask.h 1.52 2007/04/15 12:13:22 ilelpa Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tommask.h $
//	file version:	$Revision: 1.52 $
//
//	purpose:	The ProxyConsole class
//		Responsibilities:
//		1. Display "trace" output. For this it has a file
//		   "OMTracer.cfg" where names and mask pairs appear
//			the ProxyConsole "observes" these items accordingly
//				others get the default mask
//
//	author(s):	  Yachin Pnueli
//	date started:	18.6.96
//	date changed:	$Date: 2007/04/15 12:13:22 $
//	last change by:	$Author: ilelpa $
//
//	(c) Copyright Telelogic 1995, 2007
//

#include "toxf.h"
#include "tomabso.h"
#include "tomout.h"
#include <oxf/ommap.h>

	#ifdef OM_STL
	#include <fstream>
	#else
	#include <fstream.h>
	#endif

//
//	TOMProxyConsole	-	The Proxy Console 
//
const int defaultInterestMask = OMAllInterest;

class AnimOpCallReply;

class RP_ANIM_DLL TOMProxyConsole : public TOMUniversalObserver {
	// Global attributes
	static const OMString tomAniOut;
	static TOMProxyConsole* _instance;

	// output attributes
	OMMap<OMString, omostream *> outputMap;
	TOMTracerOutput tracerOutput;

	// outputs to guard against double messaging
	char *lastNotify;

	TOMProxyConsole();
#ifdef OM_OS_NEED_EXPLICIT_DISABLE_COPY_CTOR
	// explicitly disable the copy CTOR & operator = ()
	TOMProxyConsole(TOMProxyConsole&) { }
	TOMProxyConsole& operator = (TOMProxyConsole&) { return *this; }
#endif // OM_OS_NEED_EXPLICIT_DISABLE_COPY_CTOR

  	// Sub methods of reset
	OMBoolean handleOutput(omifstream& file);
	OMBoolean handleObject(omifstream& file, char * item);

	// attributes for multi-notification


	void printEventEvent(TOMInstance *, TOMInstance *, const char *, OMString);
	void printTimeoutEvent(TOMInstance *, const char *, OMString);

public:
	virtual ~TOMProxyConsole();
	// If instance is NULL create it. Then return instance
	static TOMProxyConsole* createInstance();
	// NOTE: method may return NULL. It never creates the instance !!
	static TOMProxyConsole* instance() { return _instance; }

	void addAnimationOutput(omostream* animOs) {
		addToOutputMap(tomAniOut,animOs);
	}
	void addToOutputMap(const OMString s, omostream* newOs);
	void addToOutputMap(OMString s);
	void removeFromOutputMap(const OMString s);

	void notifyNewMessage() { lastNotify = (char*)(""); }
	//
	//	Notify methods - actually common to all "observers
	//
	void notifyInstanceCreated(const TOMInstance *, const TOMInstance *);
	void notifyInstanceDeleted(const TOMInstance *, const TOMInstance *);
	void notifyClassValues(TOMClass *);
	void notifyEventValues(TOMPackage* p);

	void notifyTerminationReached(const TOMInstance *);
	void notifyEnteredState(const TOMInstance *, char *);
	void notifyExitedState(const TOMInstance *, char *);
	void notifyStateConfiguration(const TOMInstance *,
								  OMList<OMHandle *>*,
								  OMBoolean);
	void notifyBehaviorStep(
		OMList<OMHandle *>* currentStates,
		OMList<OMHandle *>* previousStates,
		OMList<OMHandle *>* currentTransitions,
		OMBoolean isTerminated	);


	void notifyRelationConnected(const TOMInstance* ,
								 OMHandle* ,
								 const TOMInstance* ,OMBoolean ,OMBoolean );
	void notifyRelationDisconnected(const TOMInstance* ,
									OMHandle* ,
									const TOMInstance* );
	void notifyRelationCleared(const TOMInstance* owner, 
							   OMHandle* relationName);
	void notifyRelationValues(TOMList*, const TOMInstance*);
	void notifyRelationsValues(TOMInstance* item);
	void notifyAttributeValues(OMList<TOMAttributeItem *> *, 
							   const TOMProxyItem *, 
							   OMBoolean);
	void notifyNewName(TOMInstance* item, OMString* oldName);

	void notifyMethodCalled(TOMInstance*, TOMInstance*, OMString, OMMethodType);
	void notifyMethodReturned(TOMInstance*, TOMInstance*, OMString, OMMethodType);
	void notifyCallStackValues(OMSData * msg);
	void notifyEventSent(TOMInstance*, TOMInstance*, OMString, void*);
	void notifyEventReceived(TOMInstance*, TOMInstance*, OMString, void*);
	void notifyEventQueueValues(OMSData * msg);
	void notifyEventQueueNull();
	void notifyTimeoutSet(TOMInstance * item,OMString event, void*);
	void notifyEventCancelled(TOMInstance * item,OMString event, void*);

	void notifyBreakPointValues(TOMBreakPointManager*);
	void notifyBreakPointActive(OMNotify theType, 
							    TOMProxyItem * theItem, 
							   const char *theData);
	void notifyThreadValues(OMList<TOMThread *>*);

	void notifyRawMessage(const char *c, OMBoolean t=TRUE);
	void notifyMessage(const char *);

	void notifyOpCallReply(AnimOpCallReply *reply, OMString& cmdStr, OMString& retValStr, OMBoolean& exception);
	/* Added to suppress MULTI/INTEGRITY 5 warning about override intended? */
	virtual void notifyOpCallReply(OMString /* cmdStr */, OMString /* retValStr */, OMBoolean /* exception */ ) { }

	void allowOutput() { tracerOutput.allowOutput(); }
	void disallowOutput() { tracerOutput.disallowOutput(); }
	void setOutputTraceTime(int mask) { tracerOutput.setTraceTime(mask); }

};

//
// $Log: tommask.h $
// Revision 1.52  2007/04/15 12:13:22  ilelpa
// Added a comment 
// Revision 1.51  2007/04/15 12:04:36  ilvler
// 102946
// Revision 1.50  2007/03/21 14:22:53  ilelpa
// Added a notification for operation call reply
// Revision 1.49  2007/03/11 13:14:43  ilgiga
// Change copyright comment
// Revision 1.48  2007/03/04 15:07:33  ilgiga
// Telelogic instead of i-Logix
// Revision 1.47  2006/04/06 14:23:42  yzharkovsky
// Fix for Linux compilation error.
// Revision 1.46  2006/04/04 13:55:20  yzharkovsky
// Multi language refactoring:
// isLang static calls were changed to context related calls.
// Revision 1.45  2004/05/11 08:01:19  vova
// Linux warnings: "virtual" added to destructor
// Revision 1.44  2002/07/29 09:23:43  Eldad
// Merge 1.41.3.1 + 1.43
// Revision 1.43  2002/07/15 12:29:32  avrahams
// Back to main
// Revision 1.42  2002/07/10 15:49:45  amos
// framework cleanup from RTOS specific code - back to r41 main branch
// Revision 1.41.2.3  2002/07/10 15:49:45  amos
// fix include order
// Revision 1.41.2.2  2002/07/09 12:03:03  amos
// replace adaptor specific #ifdef with generic statements
// Revision 1.41.2.1  2000/12/25 10:52:18  amos
// Revision 1.41.1.2  2002/07/04 11:15:29  avrahams
// Cleanup stdnamespace usage
// Revision 1.41.1.1  2000/12/25 10:52:18  avrahams
// Duplicate revision
// Revision 1.41.3.1  2002/07/29 09:21:45  Eldad
// Revision 1.41  2000/12/25 10:52:18  amos
// move to warning level 4
// Revision 1.40  2000/07/19 13:24:42  beery
// Comply with Solaris strict checking of assign "" to char*
// Revision 1.39  2000/07/12 06:54:24  amos
// changes related to modify char* to const char*.
// Revision 1.38  1999/11/08 15:09:36  zvika
// Add DLLs.
// Revision 1.37  1999/08/11 17:03:13  beery
// adding timestamp in tracer mode
// Revision 1.36  1998/08/02 15:07:43  beery
// Revision 1.35  1998/05/21 11:24:06  yachin
// Fix bug 5603 (have getPackage return a TOMPackage and not a TOMProxyItem)
// Revision 1.34  1998/04/13 07:40:59  ofer
// added "using namespace std;" after each include to stl files
// Revision 1.33  1998/04/12 12:17:45  ofer
// Change includes to Stl format ifdefed by OM_USE_STL
// Revision 1.32  1997/07/20 11:36:37  yachin
// Adding globals to animation
// Revision 1.31  1997/02/21 08:56:43  yachin
// Added show #all events
// Revision 1.30  1997/02/16 09:19:56  yachin
// removed "theClass" from InstanceCreated and InstanceDeleted
// Revision 1.29  1997/01/27 09:41:55  yachin
// Enter foreign threads
// Revision 1.28  1997/01/21 11:08:46  yachin
// changed _int32 to int
// Revision 1.27  1996/12/26 09:48:44  yachin
// Revision 1.26  1996/12/23 11:51:09  yachin
// Add ids to events
// Revision 1.25  1996/12/22 13:13:52  yachin
// Revision 1.23  1996/12/22 09:03:25  yachin
// Has composite notify componentes abou tits new name
// Revision 1.22  1996/11/24 12:40:40  yachin
// Revision 1.21  1996/11/05 07:54:38  yachin
// Revision 1.20  1996/11/05 07:20:18  yachin
// Fixed crash in "end animation"
// Revision 1.19  1996/10/21 11:39:25  yachin
// Cleanup on state notifies + fixes on timeouts + support for breakpoints
// Revision 1.18  1996/10/14 13:26:20  yachin
// Handle sub classes and set/cancel timeout
// Revision 1.17  1996/10/10 08:01:26  yachin
// Revision 1.16  1996/10/09 07:37:08  yachin
// Revision 1.15  1996/10/02 13:55:48  yachin
// Fix the double event bug
// Revision 1.14  1996/09/25 13:45:45  yachin
// Minor Bug fixes
// Revision 1.13  1996/09/25 10:01:25  yachin
// notifyEventQueueValues added + assorted bug fixes
// Revision 1.12  1996/09/17 13:43:01  yachin
// Revision 1.11  1996/09/16 12:41:40  ofer
// deregistration changed to allow non closed ostreams
// like we are using in o-mate (output window)(tommask.cpp/h)
// Revision 1.10  1996/09/16 09:28:32  yachin
// Revision 1.9  1996/09/08 13:28:58  yachin
// Registeration of items which do not yet exist
// Revision 1.8  1996/09/04 13:16:10  yachin
// Connect with Israel
// Revision 1.7  1996/09/03 12:01:15  yachin
// Alow show #callStack
// Revision 1.6  1996/08/28 08:28:58  ofer
// Revision 1.5  1996/08/12 12:28:49  yachin
// Unified Interface for "file" and "stdin". seperated show from trace
// Revision 1.4  1996/08/06 12:52:06  yachin
// Version for Prototype 4
// Revision 1.3  1996/07/10 05:50:09  yachin
// Reprecussion of reorganizatio nof AOM
// Revision 1.2  1996/06/20 10:23:10  yachin
// Revision 1.1  1996/06/19 10:20:45  yachin
// Initial revision
// Revision 1.1  1996/06/17 05:40:52  yachin
// Initial revision
//

#endif
