#ifndef tominst_H
#define tominst_H "$Id: tominst.h 1.57 2007/03/11 13:14:42 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tominst.h $
//	file version:	$Revision: 1.57 $
//
//	purpose:	Super class of all Tracer "inst" items
//
//	author(s):	  Yachin Pnueli
//	date started:	20.5.96
//	date changed:	$Date: 2007/03/11 13:14:42 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//
#include "tomproxy.h"
#include "TOMPartObserver.h"

//
//	TOMInstance	-	The Proxy Instances
//
class TOMAttributes;
class TOMState;
class TOMList;
class TOMClass;
class TOMPackage;

class RP_ANIM_DLL TOMInstance :public TOMProxyItem {
private:
	// TOMInstance data members
	int multiplicity;	// This is part of my name (name[multiplicity])
	TOMAttributes *attributes;
	OMList<TOMList *> myLinks;
	TOMState* myState;
	int hasControl;
	TOMClass * myClass;


	// Interest mask methods
	int myDefaultMask() const { 
		return OMExistInterest | OMRelationInterest; }
	OMInterestMask _setInterestMask(OMInterestMask theMask);

	// Relation methods
	void handleRelations(TOMSData * s, OMSPosition& p);
	TOMList * addLink(char * linkName, 
							OMBoolean isComposite, OMBoolean isSingleton);

	// Special for "MSC" type constructors
	void _notifyCreatedForMSC();
	void notifyCreatedForMSC(OMBoolean withComponents = TRUE);
	// Other
	OMString& outputMultiplicity(OMString& s) const;


	void _showYourself(TOMUniversalObserver* obs, int& theMask);

	TOMAttributes *getAttributes();

protected:
	// get the instance that contains me, NULL if I am not a part
	TOMInstance *getOwnerInstance() const;

public:
	virtual ~TOMInstance();
	TOMInstance(void * theReal);

	// Name methods
	int getMultiplicity() const { return multiplicity; }
	virtual OMString& outputFirstName(OMString& s) const;
	virtual OMString& outputFullName(OMString& s, 
			const TOMProxyItem * theContext = OMSystemContext) const;
	void notifyNewName(OMString* oldName=NULL);
	void setName(char * theName, 
				 int theMultiplicity,
				 const TOMProxyItem * theContext);
		// Change the name of the instnace. Currently only by a "name Giver" 
		// In future by user also.

	// Class methods
	TOMClass * getClass() const { return myClass; }
	virtual TOMPackage* getPackage() const;
	void setClass(	char * theName, 
					const int theMultiplicity, 
					OMInterestMask theMask,
					TOMClass * theClass,
					const TOMProxyItem * theContext);


	void setInterestMask(OMInterestMask theMask);

	void createRelations(TOMSData * s);
	void createRelationsFirstInstance(TOMSData * s);
	TOMList * getLinkByName(OMString linkName) const;
	OMList<TOMList *>* getLinks() { return &myLinks; }

	// return TRUE if I am an aggregate of the possibleOwner
	OMBoolean isPartOf(const TOMInstance* possibleOwner) const;

	// return TRUE if possible part is an aggregate of mine (by composition)
	OMBoolean isMyPart(const TOMInstance* possiblePart) const;


	void handleStateConfiguration(TOMSData * s, OMSPosition p);
	void handleMessage(OMNotify r, TOMSData* s, OMSPosition p);
	virtual void handleMessage(AnimMessage* msg) { TOMProxyItem::handleMessage(msg); }

	TOMProxyItem* name2Item(char *& name) const;

	// Notify methods
	void notifyConstructionFinished(const TOMInstance * myCreator);
	void notifyYouAreCreator(const TOMInstance* created);
	void notifyYouAreDeleted(const TOMInstance * myDestroyer);
	void notifyYouAreDestroyer(const TOMInstance* destroyed);
	void notifyMethodCalled(TOMInstance*, TOMInstance*, OMString, OMMethodType);
	void notifyMethodReturned(TOMInstance*, TOMInstance*, OMString, OMMethodType);
	void notifyEventSent(TOMInstance *, TOMInstance *, OMString, void*);
	void notifyEventReceived(TOMInstance *, TOMInstance *, OMString, void*);
	void notifyTimeoutSet(OMString, void*);
	void notifyEventCancelled(OMString, void*);

	// accept a visitor, and execute its wishes
	virtual void accept(TOMProxyVisitor1Arg & visitor);

	// query myState
	TOMState* getState() const { return myState; }
	

	TOMPartObserver* getTomInstancePartObserver() const { return tomInstancePartObserver; }

	
	// delegation method for part observation	
	virtual void notifyPartEventReceived(TOMInstance * /* sender */,
		TOMInstance * /* receiver */,
		OMString /* event */,
		void* /* eventId */,
		TOMInstance* /* theOwner */);
	
	virtual void notifyPartEventSent(TOMInstance * /* sender */,
		TOMInstance * /* receiver */,
		OMString /* event */,
		void* /* eventId */,
		TOMInstance* /* theOwner */);
	
	virtual void notifyPartMethodCalled(TOMInstance* /* caller */,
		TOMInstance* /* called */,
		OMString /* method */,
		OMMethodType,
		TOMInstance* /* theOwner */);
	
	virtual void notifyPartMethodReturned(TOMInstance* /* caller */,
		TOMInstance* /* called */,
		OMString /* method */,
		OMMethodType,
		TOMInstance* /* theOwner */);
	
	virtual void notifyPartConnected(TOMInstance* theOwner,
		TOMInstance* thePart) ;
	
	// Part observer management
	void addPartObserver(TOMPartObserver* partObserver);
	void removePartObserver(TOMPartObserver* partObserver);
	void removePartObserverRecursive(TOMPartObserver* partObserver);



	// since EC++ forbids multiple inheritance the whole part observation
	// agenda is delegated into a nested class that inherits TOMPartObserver
	class TOMInstancePartObserver : public TOMPartObserver
	{
	public:
	
		TOMInstancePartObserver(TOMInstance* theInstance) : tomInstance(theInstance){}
		virtual ~TOMInstancePartObserver() {}
		// Part Observers notifications
		virtual void notifyPartEventReceived(TOMInstance * /* sender */,
											 TOMInstance * /* receiver */,
											 OMString /* event */,
											 void* /* eventId */,
											 TOMInstance* /* theOwner */);
		
		virtual void notifyPartEventSent(TOMInstance * /* sender */,
			TOMInstance * /* receiver */,
			OMString /* event */,
			void* /* eventId */,
			TOMInstance* /* theOwner */);
		
		virtual void notifyPartMethodCalled(TOMInstance* /* caller */,
			TOMInstance* /* called */,
			OMString /* method */,
			OMMethodType,
			TOMInstance* /* theOwner */);
		
		virtual void notifyPartMethodReturned(TOMInstance* /* caller */,
			TOMInstance* /* called */,
			OMString /* method */,
			OMMethodType,
			TOMInstance* /* theOwner */);
		
		virtual void notifyPartConnected(TOMInstance* /*theOwner*/,
										  TOMInstance* /*thePart*/);
		
		// Part observer management
		void addPartObserver(TOMPartObserver* partObserver);
		void removePartObserver(TOMPartObserver* partObserver);
		void removePartObserverRecursive(TOMPartObserver* partObserver);
		
		
	private:
		
		OMList<TOMPartObserver*> myPartObservers;
		TOMInstance* tomInstance;
		
	};
	
protected:
	TOMInstancePartObserver* tomInstancePartObserver;


};



inline omostream& operator<<(omostream& os, TOMInstance *item) {
	return os<<(TOMProxyItem *)item;
}

//
// $Log: tominst.h $
// Revision 1.57  2007/03/11 13:14:42  ilgiga
// Change copyright comment
// Revision 1.56  2007/03/04 15:07:32  ilgiga
// Telelogic instead of i-Logix
// Revision 1.55  2004/05/11 08:00:43  vova
// Linux warnings: "virtual" added to destructor
// Revision 1.54  2003/12/28 14:50:21  eldad
// Fixed compilation
// Revision 1.53  2003/12/28 12:54:14  eldad
// Removed multiple inheritance
// Revision 1.52  2003/12/25 12:06:10  eldad
// Black Box Animation
// Revision 1.51  2003/12/24 14:34:26  eldad
// Black Box Animation Support - Compositional Hierarchy
// Revision 1.50.1.4  2003/12/23 16:19:19  eldad
// Revision 1.50.1.3  2003/12/22 16:03:47  eldad
// Revision 1.50.1.2  2003/12/22 15:31:09  eldad
// Revision 1.50.1.1  2003/06/16 05:45:12  eldad
// Duplicate revision
// Revision 1.49  2002/08/06 08:25:00  Eldad
// Fixed warnings in Solaros Adaptor.
// Revision 1.48  2002/07/15 12:29:31  avrahams
// Back to main
// Revision 1.47  2002/04/23 12:29:44  Eldad
// 
// --- Added comments ---  Eldad [2002/04/23 12:30:24 GMT]
// Added a getter to myState
// Revision 1.47.1.2  2002/07/04 11:10:09  avrahams
// Cleanup std namespace usage
// Revision 1.47.1.1  2002/04/23 12:29:44  avrahams
// Duplicate revision
// Revision 1.46.1.1  2000/11/14 14:29:28  Eldad
// Duplicate revision
// Revision 1.45  1999/11/08 15:09:35  zvika
// Add DLLs.
// Revision 1.44  1999/10/12 13:33:01  yachin
// Fix bugs
// Revision 1.43  1999/02/16 05:56:56  yachin
// Speed up of constructors
// Revision 1.42  1998/11/17 12:17:16  beery
// Revision 1.41  1998/08/02 15:07:42  beery
// Revision 1.40  1998/05/21 11:24:05  yachin
// Fix bug 5603 (have getPackage return a TOMPackage and not a TOMProxyItem)
// Revision 1.39  1997/02/20 10:04:34  yachin
// Dead objects no longer update their masks
// Revision 1.38  1997/02/16 09:19:56  yachin
// removed "theClass" from InstanceCreated and InstanceDeleted
// Revision 1.37  1997/02/13 09:57:42  yachin
// removed isComposite isSingleton from the connectRelation message
// Revision 1.36  1997/02/11 12:54:34  yachin
// Adding Name spaces
// Revision 1.35  1997/01/22 11:54:10  yachin
// Inverse composite relation bug fix
// Revision 1.34  1997/01/21 11:08:46  yachin
// changed _int32 to int
// Revision 1.33  1997/01/13 11:38:58  yachin
// Make constructor/destructor mult=2 notifications
// Revision 1.32  1996/12/23 11:51:07  yachin
// Add ids to events
// Revision 1.31  1996/12/22 09:03:23  yachin
// Has composite notify componentes abou tits new name
// Revision 1.30  1996/12/11 13:25:06  yachin
// Revision 1.29  1996/12/08 10:15:41  yachin
// Revision 1.28  1996/11/24 12:40:38  yachin
// Revision 1.27  1996/11/05 13:45:35  yachin
// Change getType to non virtual add myType attribute
// Revision 1.26  1996/10/27 11:57:36  yachin
// getLinkByName(OMString linkName) made public
// Revision 1.25  1996/10/14 13:26:19  yachin
// Handle sub classes and set/cancel timeout
// Revision 1.24  1996/10/09 07:37:06  yachin
// Revision 1.23  1996/10/02 08:40:53  yachin
// Hopefully fixed "early" relation registration bug
// Revision 1.22  1996/10/01 11:42:53  yachin
// Fix registraction bug in relations
// Revision 1.21  1996/09/24 13:56:29  yachin
// Revision 1.20  1996/09/19 12:31:39  yachin
// add class info to TOMInstance
// Revision 1.19  1996/09/16 13:44:30  yachin
// Revision 1.18  1996/09/16 09:28:31  yachin
// Revision 1.17  1996/09/08 13:28:56  yachin
// Registeration of items which do not yet exist
// Revision 1.16  1996/09/05 13:35:55  yachin
// Revision 1.15  1996/09/04 13:16:09  yachin
// Connect with Israel
// Revision 1.14  1996/08/29 11:27:36  ofer
// Revision 1.13  1996/08/14 12:40:24  yachin
// Seperate TOM Masks from AOM Masks. Fix bugs with attr. and states
// Revision 1.12  1996/08/08 08:23:28  yachin
// Revision 1.11  1996/08/06 12:52:06  yachin
// Version for Prototype 4
// Revision 1.10  1996/07/24 09:13:22  yachin
// Fxi a bug for Beeri
// Revision 1.9  1996/07/22 11:30:30  yachin
// Revision 1.8  1996/07/10 09:13:06  yachin
// Revision 1.7  1996/07/10 05:50:09  yachin
// Reprecussion of reorganizatio nof AOM
// Revision 1.6  1996/07/04 12:38:49  yachin
// Bug fixes and handleing static methods
// Revision 1.5  1996/07/02 10:17:24  yachin
// Componnet/Relation distinction
// Revision 1.4  1996/06/30 07:57:38  yachin
// Bug fix for case of none interesting call stack items/event senders/receivers
// Revision 1.3  1996/06/25 11:53:37  yachin
// Revision 1.2  1996/06/19 10:21:27  yachin
// Revision 1.1  1996/06/17 05:40:44  yachin
// Initial revision
//

#endif
